/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.lifecycle;

import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.lifecycle.LifecycleRegistry;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleHiveMQShutdownHook
implements HiveMQShutdownHook {
    private static final Logger log = LoggerFactory.getLogger(LifecycleHiveMQShutdownHook.class);
    @NotNull
    private final LifecycleRegistry lifecycleRegistry;

    @Inject
    LifecycleHiveMQShutdownHook(@NotNull LifecycleRegistry lifecycleRegistry) {
        this.lifecycleRegistry = lifecycleRegistry;
    }

    @Override
    @NotNull
    public String name() {
        return "Lifecycle Shutdown";
    }

    @Override
    @NotNull
    public HiveMQShutdownHook.Priority priority() {
        return HiveMQShutdownHook.Priority.HIGH;
    }

    @Override
    public void run() {
        try {
            this.lifecycleRegistry.executePreDestroy().get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Exceptions in lifecycle shutdown", (Throwable)e);
        }
    }
}

