/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence.legacy;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.migration.persistence.legacy.PublishPayloadLocalPersistence_4_4;
import com.hivemq.migration.persistence.legacy.serializer.PublishPayloadXodusSerializer_4_4;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.local.xodus.EnvironmentUtil;
import com.hivemq.persistence.local.xodus.XodusLocalPersistence;
import com.hivemq.persistence.local.xodus.XodusUtils;
import com.hivemq.persistence.local.xodus.bucket.Bucket;
import com.hivemq.persistence.payload.PublishPayloadXodusLocalPersistence;
import com.hivemq.util.LocalPersistenceFileUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class PublishPayloadXodusLocalPersistence_4_4
extends XodusLocalPersistence
implements PublishPayloadLocalPersistence_4_4 {
    private static final Logger log = LoggerFactory.getLogger(PublishPayloadXodusLocalPersistence.class);
    public static final String PERSISTENCE_VERSION = "040000";
    private static final int CHUNK_SIZE = 0x500000;
    @NotNull
    private final PublishPayloadXodusSerializer_4_4 serializer = new PublishPayloadXodusSerializer_4_4();

    @Inject
    public PublishPayloadXodusLocalPersistence_4_4(@NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull EnvironmentUtil environmentUtil, @NotNull PersistenceStartup persistenceStartup) {
        super(environmentUtil, localPersistenceFileUtil, persistenceStartup, InternalConfigurations.PAYLOAD_PERSISTENCE_BUCKET_COUNT.get(), false);
    }

    @Override
    @NotNull
    protected String getName() {
        return "publish_payload_store";
    }

    @Override
    @NotNull
    protected String getVersion() {
        return PERSISTENCE_VERSION;
    }

    @Override
    @NotNull
    protected StoreConfig getStoreConfig() {
        return StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return log;
    }

    @Override
    @PostConstruct
    protected void postConstruct() {
        super.postConstruct();
    }

    @Override
    public void init() {
    }

    @Override
    @Nullable
    public byte[] get(long id) {
        Bucket bucket = this.getBucket(Long.toString(id));
        return (byte[])bucket.getEnvironment().computeInReadonlyTransaction(transaction -> {
            HashMap<Long, byte[]> chunks = new HashMap<Long, byte[]>();
            try (Cursor cursor = bucket.getStore().openCursor(transaction);){
                int chunkIndex = 0;
                ByteIterable entry = cursor.getSearchKey(XodusUtils.bytesToByteIterable(this.serializer.serializeKey(id, chunkIndex)));
                if (entry == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                do {
                    KeyPair key = this.serializer.deserializeKey(XodusUtils.byteIterableToBytes(cursor.getKey()));
                    chunks.put(key.getChunkIndex(), XodusUtils.byteIterableToBytes(cursor.getValue()));
                } while ((entry = cursor.getSearchKey(XodusUtils.bytesToByteIterable(this.serializer.serializeKey(id, ++chunkIndex)))) != null);
            }
            if (chunks.size() < 1) {
                return null;
            }
            if (chunks.size() == 1) {
                return (byte[])chunks.values().iterator().next();
            }
            int resultSize = 0;
            for (byte[] bytes : chunks.values()) {
                resultSize += bytes.length;
            }
            byte[] result = new byte[resultSize];
            for (Map.Entry entry : chunks.entrySet()) {
                System.arraycopy(entry.getValue(), 0, result, (int)((Long)entry.getKey() * 0x500000L), ((byte[])entry.getValue()).length);
            }
            return result;
        });
    }

    @Override
    public void put(long id, @NotNull byte[] payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"payload must not be null");
        Bucket bucket = this.getBucket(Long.toString(id));
        bucket.getEnvironment().executeInTransaction(txn -> {
            int chunkIndex = 0;
            do {
                ByteIterable key = XodusUtils.bytesToByteIterable(this.serializer.serializeKey(id, chunkIndex));
                if (payload.length < 0x500000) {
                    bucket.getStore().put(txn, key, XodusUtils.bytesToByteIterable(payload));
                    continue;
                }
                int currentChunkSize = payload.length - chunkIndex * 0x500000;
                if (currentChunkSize >= 0x500000) {
                    currentChunkSize = 0x500000;
                }
                byte[] chunk = new byte[currentChunkSize];
                System.arraycopy(payload, chunkIndex * 0x500000, chunk, 0, currentChunkSize);
                bucket.getStore().put(txn, key, XodusUtils.bytesToByteIterable(chunk));
            } while (payload.length > ++chunkIndex * 0x500000);
        });
    }

    public static class KeyPair {
        private final long id;
        private final long chunkIndex;

        public KeyPair(long id, long chunkIndex) {
            this.id = id;
            this.chunkIndex = chunkIndex;
        }

        long getChunkIndex() {
            return this.chunkIndex;
        }

        public long getId() {
            return this.id;
        }
    }
}

