/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence.retained;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.ValueMigration;
import com.hivemq.migration.logging.PayloadExceptionLogging;
import com.hivemq.migration.meta.MetaFileService;
import com.hivemq.migration.meta.MetaInformation;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.migration.persistence.legacy.PublishPayloadLocalPersistence_4_4;
import com.hivemq.migration.persistence.legacy.PublishPayloadRocksDBLocalPersistence_4_4;
import com.hivemq.migration.persistence.legacy.PublishPayloadXodusLocalPersistence_4_4;
import com.hivemq.migration.persistence.legacy.RetainedMessageItemCallback_4_4;
import com.hivemq.migration.persistence.legacy.RetainedMessageRocksDBLocalPersistence_4_4;
import com.hivemq.migration.persistence.legacy.RetainedMessageXodusLocalPersistence_4_4;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.persistence.local.xodus.RetainedMessageRocksDBLocalPersistence;
import com.hivemq.persistence.local.xodus.RetainedMessageXodusLocalPersistence;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.persistence.retained.RetainedMessageLocalPersistence;
import com.hivemq.util.Exceptions;
import com.hivemq.util.LocalPersistenceFileUtil;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class RetainedMessagePayloadIDMigration
implements ValueMigration {
    private static final Logger log = LoggerFactory.getLogger(RetainedMessagePayloadIDMigration.class);
    private static final Logger migrationLog = LoggerFactory.getLogger((String)"migrations");
    private static final String FIRST_BUCKET_FOLDER = "retained_messages_0";
    @NotNull
    private final Provider<RetainedMessageXodusLocalPersistence_4_4> retainedMessageXodusLocalPersistence_4_4Provider;
    @NotNull
    private final Provider<RetainedMessageRocksDBLocalPersistence_4_4> retainedMessageRocksDBLocalPersistence_4_4Provider;
    @NotNull
    private final Provider<PublishPayloadXodusLocalPersistence_4_4> publishPayloadXodusLocalPersistence_4_4Provider;
    @NotNull
    private final Provider<PublishPayloadRocksDBLocalPersistence_4_4> publishPayloadRocksDBLocalPersistence_4_4Provider;
    @NotNull
    private final Provider<RetainedMessageXodusLocalPersistence> localXodusPersistenceProvider;
    @NotNull
    private final Provider<RetainedMessageRocksDBLocalPersistence> localRocksPersistenceProvider;
    @NotNull
    private final LocalPersistenceFileUtil localPersistenceFileUtil;
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final PayloadExceptionLogging payloadExceptionLogging;
    private final int bucketCount;
    @NotNull
    private final AtomicReference<PersistenceType> previousPayloadType = new AtomicReference();
    @NotNull
    private final AtomicReference<PersistenceType> previousRetainedType = new AtomicReference();

    @Inject
    public RetainedMessagePayloadIDMigration(@NotNull Provider<RetainedMessageXodusLocalPersistence_4_4> retainedMessageXodusLocalPersistence_4_4Provider, @NotNull Provider<RetainedMessageRocksDBLocalPersistence_4_4> retainedMessageRocksDBLocalPersistence_4_4Provider, @NotNull Provider<PublishPayloadXodusLocalPersistence_4_4> publishPayloadXodusLocalPersistence_4_4Provider, @NotNull Provider<PublishPayloadRocksDBLocalPersistence_4_4> publishPayloadRocksDBLocalPersistence_4_4Provider, @NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull Provider<RetainedMessageXodusLocalPersistence> localXodusPersistenceProvider, @NotNull Provider<RetainedMessageRocksDBLocalPersistence> localRocksPersistenceProvider, @NotNull SystemInformation systemInformation, @NotNull PayloadExceptionLogging payloadExceptionLogging) {
        this.retainedMessageXodusLocalPersistence_4_4Provider = retainedMessageXodusLocalPersistence_4_4Provider;
        this.retainedMessageRocksDBLocalPersistence_4_4Provider = retainedMessageRocksDBLocalPersistence_4_4Provider;
        this.publishPayloadXodusLocalPersistence_4_4Provider = publishPayloadXodusLocalPersistence_4_4Provider;
        this.publishPayloadRocksDBLocalPersistence_4_4Provider = publishPayloadRocksDBLocalPersistence_4_4Provider;
        this.localPersistenceFileUtil = localPersistenceFileUtil;
        this.localRocksPersistenceProvider = localRocksPersistenceProvider;
        this.localXodusPersistenceProvider = localXodusPersistenceProvider;
        this.systemInformation = systemInformation;
        this.bucketCount = InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get();
        this.payloadExceptionLogging = payloadExceptionLogging;
    }

    private boolean oldFolderMissing(@NotNull File persistenceFolder) {
        File oldPersistenceFolder = new File(persistenceFolder, FIRST_BUCKET_FOLDER);
        if (!oldPersistenceFolder.exists()) {
            migrationLog.info("No (old) persistence folder (retained_messages) present, skipping migration.");
            log.debug("No (old) persistence folder (retained_messages) present, skipping migration.");
            return true;
        }
        return false;
    }

    private void savePersistenceVersion(@NotNull PersistenceType persistenceType) {
        MetaInformation metaFile = MetaFileService.readMetaFile(this.systemInformation);
        metaFile.setRetainedMessagesPersistenceVersion(persistenceType == PersistenceType.FILE_NATIVE ? "040500_R" : "040500");
        MetaFileService.writeMetaFile(this.systemInformation, metaFile);
    }

    @Override
    public void migrateToValue() {
        PublishPayloadLocalPersistence_4_4 legacyPayloadPersistence;
        RetainedMessageLocalPersistence retainedMessageLocalPersistence;
        File persistenceFolder;
        MetaInformation metaFile = MetaFileService.readMetaFile(this.systemInformation);
        if (metaFile.getRetainedMessagesPersistenceType() == PersistenceType.FILE_NATIVE) {
            persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder("retained_messages", "040000_R");
            if (this.oldFolderMissing(persistenceFolder)) {
                return;
            }
            retainedMessageLocalPersistence = (RetainedMessageLocalPersistence)this.localRocksPersistenceProvider.get();
            this.previousRetainedType.set(PersistenceType.FILE_NATIVE);
        } else {
            persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder("retained_messages", "040000");
            if (this.oldFolderMissing(persistenceFolder)) {
                return;
            }
            retainedMessageLocalPersistence = (RetainedMessageLocalPersistence)this.localXodusPersistenceProvider.get();
            this.previousRetainedType.set(PersistenceType.FILE);
        }
        if (metaFile.getPublishPayloadPersistenceType() == PersistenceType.FILE_NATIVE) {
            legacyPayloadPersistence = (PublishPayloadLocalPersistence_4_4)this.publishPayloadRocksDBLocalPersistence_4_4Provider.get();
            this.previousPayloadType.set(PersistenceType.FILE_NATIVE);
        } else {
            legacyPayloadPersistence = (PublishPayloadLocalPersistence_4_4)this.publishPayloadXodusLocalPersistence_4_4Provider.get();
            this.previousPayloadType.set(PersistenceType.FILE);
        }
        RetainedMessagePersistenceValueSwitchCallback iterationCallback = new RetainedMessagePersistenceValueSwitchCallback(this.bucketCount, retainedMessageLocalPersistence, this.payloadExceptionLogging, legacyPayloadPersistence);
        if (metaFile.getRetainedMessagesPersistenceType() == PersistenceType.FILE_NATIVE) {
            ((RetainedMessageRocksDBLocalPersistence_4_4)this.retainedMessageRocksDBLocalPersistence_4_4Provider.get()).iterate(iterationCallback);
            this.savePersistenceVersion(PersistenceType.FILE_NATIVE);
        } else {
            ((RetainedMessageXodusLocalPersistence_4_4)this.retainedMessageXodusLocalPersistence_4_4Provider.get()).iterate(iterationCallback);
            this.savePersistenceVersion(PersistenceType.FILE);
        }
    }

    public void closeLegacy() {
        if (this.previousPayloadType.get() == PersistenceType.FILE_NATIVE) {
            ((PublishPayloadRocksDBLocalPersistence_4_4)this.publishPayloadRocksDBLocalPersistence_4_4Provider.get()).closeDB();
        } else {
            ((PublishPayloadXodusLocalPersistence_4_4)this.publishPayloadXodusLocalPersistence_4_4Provider.get()).closeDB();
        }
        if (this.previousRetainedType.get() == PersistenceType.FILE_NATIVE) {
            ((RetainedMessageRocksDBLocalPersistence_4_4)this.retainedMessageRocksDBLocalPersistence_4_4Provider.get()).closeDB();
        } else {
            ((RetainedMessageXodusLocalPersistence_4_4)this.retainedMessageXodusLocalPersistence_4_4Provider.get()).closeDB();
        }
    }

    @VisibleForTesting
    static class RetainedMessagePersistenceValueSwitchCallback
    implements RetainedMessageItemCallback_4_4 {
        private final int bucketCount;
        @NotNull
        private final RetainedMessageLocalPersistence retainedMessageLocalPersistence;
        @NotNull
        private final PayloadExceptionLogging payloadExceptionLogging;
        @NotNull
        private final PublishPayloadLocalPersistence_4_4 legacyPayloadPersistence;

        RetainedMessagePersistenceValueSwitchCallback(int bucketCount, @NotNull RetainedMessageLocalPersistence retainedMessageLocalPersistence, @NotNull PayloadExceptionLogging payloadExceptionLogging, @NotNull PublishPayloadLocalPersistence_4_4 legacyPayloadPersistence) {
            this.bucketCount = bucketCount;
            this.retainedMessageLocalPersistence = retainedMessageLocalPersistence;
            this.payloadExceptionLogging = payloadExceptionLogging;
            this.legacyPayloadPersistence = legacyPayloadPersistence;
        }

        @Override
        public void onItem(@NotNull String topic, @NotNull RetainedMessage message) {
            try {
                int bucketIndex = BucketUtils.getBucket(topic, this.bucketCount);
                byte[] bytes = this.legacyPayloadPersistence.get(message.getPublishId());
                if (bytes == null) {
                    this.payloadExceptionLogging.addLogging(message.getPublishId(), true, topic);
                    return;
                }
                long newPayloadId = PublishPayloadPersistence.createId();
                message.setPublishId(newPayloadId);
                message.setMessage(bytes);
                this.retainedMessageLocalPersistence.put(message, topic, bucketIndex);
            }
            catch (Throwable throwable) {
                log.warn("Could not migrate retained message for topic {}, original exception: ", (Object)topic, (Object)throwable);
                Exceptions.rethrowError(throwable);
            }
        }
    }
}

