/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.connect;

import com.google.inject.Inject;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.connect.CONNECT;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.NoSuchElementException;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ChannelHandler.Sharable
public class NoConnectIdleHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(NoConnectIdleHandler.class);
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;

    @Inject
    public NoConnectIdleHandler(@NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.mqttServerDisconnector = mqttServerDisconnector;
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof CONNECT) {
            try {
                ctx.pipeline().remove("new_connection_idle_handler");
                ctx.pipeline().remove((ChannelHandler)this);
            }
            catch (NoSuchElementException ignored) {
                log.trace("Not able to remove no connect idle handler.");
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            this.mqttServerDisconnector.logAndClose(ctx.channel(), "Client with IP {} disconnected. The client was idle for too long without sending a MQTT CONNECT packet.", "No CONNECT sent in time");
        }
        ctx.fireUserEventTriggered(evt);
    }
}

