/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.publish;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.publish.PublishStatus;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.publish.PublishWithFuture;
import com.hivemq.mqtt.message.publish.PubrelWithFuture;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedTopicService {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(OrderedTopicService.class);
    @NotNull
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = new ClosedChannelException();
    @NotNull
    private final Map<Integer, SettableFuture<PublishStatus>> messageIdToFutureMap = new ConcurrentHashMap<Integer, SettableFuture<PublishStatus>>();
    @VisibleForTesting
    @NotNull
    final Queue<QueuedMessage> queue = new ArrayDeque<QueuedMessage>();
    @NotNull
    private final AtomicBoolean closedAlready = new AtomicBoolean(false);
    @NotNull
    private final Set<Integer> unacknowledgedMessages = ConcurrentHashMap.newKeySet();

    public void messageFlowComplete(@NotNull ChannelHandlerContext ctx, int packetId) {
        int maxInflightWindow;
        boolean removed;
        SettableFuture<PublishStatus> publishStatusFuture = this.messageIdToFutureMap.get(packetId);
        if (publishStatusFuture != null) {
            this.messageIdToFutureMap.remove(packetId);
            publishStatusFuture.set((Object)PublishStatus.DELIVERED);
        }
        if (!(removed = this.unacknowledgedMessages.remove(packetId))) {
            return;
        }
        if (this.queue.isEmpty()) {
            return;
        }
        ClientConnection clientConnection = ClientConnection.of(ctx.channel());
        int n = maxInflightWindow = clientConnection == null ? InternalConfigurations.MAX_INFLIGHT_WINDOW_SIZE_MESSAGES : clientConnection.getMaxInflightWindow(InternalConfigurations.MAX_INFLIGHT_WINDOW_SIZE_MESSAGES);
        do {
            QueuedMessage poll;
            if ((poll = this.queue.poll()) == null) {
                return;
            }
            this.unacknowledgedMessages.add(poll.publish.getPacketIdentifier());
            ctx.writeAndFlush((Object)poll.getPublish(), poll.getPromise());
        } while (this.unacknowledgedMessages.size() < maxInflightWindow);
    }

    public boolean handlePublish(@NotNull Channel channel, @NotNull Object msg, @NotNull ChannelPromise promise) {
        ClientConnection clientConnection;
        if (msg instanceof PubrelWithFuture) {
            PubrelWithFuture pubrelWithFuture = (PubrelWithFuture)msg;
            this.messageIdToFutureMap.put(pubrelWithFuture.getPacketIdentifier(), pubrelWithFuture.getFuture());
            return false;
        }
        if (!(msg instanceof PUBLISH)) {
            return false;
        }
        SettableFuture<PublishStatus> future = null;
        if (msg instanceof PublishWithFuture) {
            PublishWithFuture publishWithFuture = (PublishWithFuture)msg;
            future = publishWithFuture.getFuture();
        }
        if ((clientConnection = ClientConnection.of(channel)) == null) {
            return false;
        }
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return false;
        }
        PUBLISH publish = (PUBLISH)msg;
        int qosNumber = publish.getQoS().getQosNumber();
        if (log.isTraceEnabled()) {
            log.trace("Client {}: Sending PUBLISH QoS {} Message with packet id {}", new Object[]{clientId, publish.getQoS().getQosNumber(), publish.getPacketIdentifier()});
        }
        if (qosNumber < 1) {
            if (future != null) {
                future.set((Object)PublishStatus.DELIVERED);
            }
            return false;
        }
        if (future != null) {
            this.messageIdToFutureMap.put(publish.getPacketIdentifier(), future);
        }
        if (this.closedAlready.get()) {
            promise.setFailure((Throwable)CLOSED_CHANNEL_EXCEPTION);
            return true;
        }
        if (this.unacknowledgedMessages.size() >= clientConnection.getMaxInflightWindow(InternalConfigurations.MAX_INFLIGHT_WINDOW_SIZE_MESSAGES)) {
            this.queueMessage(promise, publish, clientId);
            return true;
        }
        this.unacknowledgedMessages.add(publish.getPacketIdentifier());
        return false;
    }

    public void handleInactive() {
        this.closedAlready.set(true);
        for (QueuedMessage queuedMessage : this.queue) {
            if (queuedMessage == null || queuedMessage.getPromise().isDone()) continue;
            queuedMessage.getPromise().setFailure((Throwable)CLOSED_CHANNEL_EXCEPTION);
        }
        for (Map.Entry entry : this.messageIdToFutureMap.entrySet()) {
            SettableFuture publishStatusFuture = (SettableFuture)entry.getValue();
            publishStatusFuture.set((Object)PublishStatus.NOT_CONNECTED);
        }
    }

    private void queueMessage(@NotNull ChannelPromise promise, @NotNull PUBLISH publish, @NotNull String clientId) {
        if (log.isTraceEnabled()) {
            String topic = publish.getTopic();
            int messageId = publish.getPacketIdentifier();
            log.trace("Buffered publish message with qos {} packetIdentifier {} and topic {} for client {}, because the receive maximum is exceeded", new Object[]{publish.getQoS().name(), messageId, topic, clientId});
        }
        this.queue.add(new QueuedMessage(publish, promise));
    }

    @NotNull
    public Set<Integer> unacknowledgedMessages() {
        return this.unacknowledgedMessages;
    }

    static {
        CLOSED_CHANNEL_EXCEPTION.setStackTrace(new StackTraceElement[0]);
    }

    @VisibleForTesting
    static class QueuedMessage {
        @NotNull
        private final PUBLISH publish;
        @NotNull
        private final ChannelPromise promise;

        QueuedMessage(@NotNull PUBLISH publish, @NotNull ChannelPromise promise) {
            this.publish = publish;
            this.promise = promise;
        }

        @NotNull
        public PUBLISH getPublish() {
            return this.publish;
        }

        @NotNull
        public ChannelPromise getPromise() {
            return this.promise;
        }
    }
}

