/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.pool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.mqtt.message.pool.exception.MessageIdUnavailableException;
import com.hivemq.mqtt.message.pool.exception.NoMessageIdAvailableException;

@ThreadSafe
public class FreePacketIdRanges {
    private static final int MIN_ALLOWED_MQTT_PACKET_ID = 1;
    @VisibleForTesting
    public static final int MAX_ALLOWED_MQTT_PACKET_ID = 65535;
    @NotNull
    private Range rootRange = new Range(1, 65536);

    public synchronized int takeNextId() throws NoMessageIdAvailableException {
        if (this.rootRange.start == this.rootRange.end) {
            throw new NoMessageIdAvailableException();
        }
        int id = this.rootRange.start++;
        if (this.rootRange.start == this.rootRange.end && this.rootRange.next != null) {
            this.rootRange = this.rootRange.next;
        }
        return id;
    }

    public synchronized void takeSpecificId(int id) throws MessageIdUnavailableException {
        Preconditions.checkArgument((id >= 1 && id <= 65535 ? 1 : 0) != 0, (String)"Attempting to take an ID %s that is outside the valid packet IDs range.", (int)id);
        Range current = this.rootRange;
        Range prev = null;
        while (current != null) {
            if (id < current.start) {
                throw new MessageIdUnavailableException(id);
            }
            if (id < current.end) {
                Range lowerRange;
                int prevCurStart = current.start;
                current.start = id + 1;
                Range range = lowerRange = prevCurStart == id ? null : new Range(prevCurStart, id, current);
                if (lowerRange != null) {
                    if (prev != null) {
                        prev.next = lowerRange;
                    } else {
                        this.rootRange = lowerRange;
                    }
                }
                while (this.rootRange.start == this.rootRange.end && this.rootRange.next != null) {
                    this.rootRange = this.rootRange.next;
                }
                return;
            }
            prev = current;
            current = current.next;
        }
    }

    public synchronized void returnId(int id) {
        Preconditions.checkArgument((id >= 1 && id <= 65535 ? 1 : 0) != 0, (String)"Attempting to return an ID %s that is outside the valid packet IDs range.", (int)id);
        Range current = this.rootRange;
        if (id < current.start - 1) {
            this.rootRange = new Range(id, id + 1, current);
            return;
        }
        Range prev = current;
        current = this.returnId(current, id);
        while (current != null) {
            if (id < current.start - 1) {
                prev.next = new Range(id, id + 1, current);
                return;
            }
            prev = current;
            current = this.returnId(current, id);
        }
    }

    @Nullable
    private Range returnId(@NotNull Range range, int id) throws IllegalStateException {
        if (id == range.start - 1) {
            range.start = id;
            return null;
        }
        if (id < range.end) {
            return null;
        }
        Range next = range.next;
        Preconditions.checkState((next != null ? 1 : 0) != 0, (Object)"The id is greater than maxId. This must not happen and is a bug.");
        if (id == range.end) {
            ++range.end;
            if (range.end == next.start) {
                range.end = next.end;
                range.next = next.next;
            }
            return null;
        }
        return next;
    }

    private static class Range {
        int start;
        int end;
        @Nullable
        Range next;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        Range(int start, int end, @NotNull Range next) {
            this.start = start;
            this.end = end;
            this.next = next;
        }
    }
}

