/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.clientqueue;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.ImmutableIntArray;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.MessageWithID;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import com.hivemq.mqtt.services.PublishPollService;
import com.hivemq.mqtt.topic.SubscriberWithQoS;
import com.hivemq.mqtt.topic.tree.LocalTopicTree;
import com.hivemq.persistence.AbstractPersistence;
import com.hivemq.persistence.ProducerQueues;
import com.hivemq.persistence.SingleWriterService;
import com.hivemq.persistence.clientqueue.ClientQueueLocalPersistence;
import com.hivemq.persistence.clientqueue.ClientQueuePersistence;
import com.hivemq.persistence.clientsession.ClientSession;
import com.hivemq.persistence.clientsession.SharedSubscriptionService;
import com.hivemq.persistence.connection.ConnectionPersistence;
import com.hivemq.persistence.local.ClientSessionLocalPersistence;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

@LazySingleton
public class ClientQueuePersistenceImpl
extends AbstractPersistence
implements ClientQueuePersistence {
    public static final int SHARED_IN_FLIGHT_MARKER = 1;
    @NotNull
    private final ClientQueueLocalPersistence localPersistence;
    @NotNull
    private final ProducerQueues singleWriter;
    @NotNull
    private final MqttConfigurationService mqttConfigurationService;
    @NotNull
    private final ClientSessionLocalPersistence clientSessionLocalPersistence;
    @NotNull
    private final LocalTopicTree topicTree;
    @NotNull
    private final ConnectionPersistence connectionPersistence;
    @NotNull
    private final PublishPollService publishPollService;

    @Inject
    public ClientQueuePersistenceImpl(@NotNull ClientQueueLocalPersistence localPersistence, @NotNull SingleWriterService singleWriterService, @NotNull MqttConfigurationService mqttConfigurationService, @NotNull ClientSessionLocalPersistence clientSessionLocalPersistence, @NotNull LocalTopicTree topicTree, @NotNull ConnectionPersistence connectionPersistence, @NotNull PublishPollService publishPollService) {
        this.localPersistence = localPersistence;
        this.mqttConfigurationService = mqttConfigurationService;
        this.clientSessionLocalPersistence = clientSessionLocalPersistence;
        this.topicTree = topicTree;
        this.connectionPersistence = connectionPersistence;
        this.publishPollService = publishPollService;
        this.singleWriter = singleWriterService.getQueuedMessagesQueue();
    }

    @Override
    @NotNull
    public ListenableFuture<Void> add(@NotNull String queueId, boolean shared, @NotNull PUBLISH publish, boolean retained, long queueLimit) {
        try {
            Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
            Preconditions.checkNotNull((Object)publish, (Object)"Publish must not be null");
        }
        catch (Exception exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
        return this.singleWriter.submit(queueId, bucketIndex -> {
            this.localPersistence.add(queueId, shared, publish, queueLimit, this.mqttConfigurationService.getQueuedMessagesStrategy(), retained, bucketIndex);
            int queueSize = this.localPersistence.size(queueId, shared, bucketIndex);
            if (queueSize == 1) {
                if (shared) {
                    this.sharedPublishAvailable(queueId);
                } else {
                    this.publishAvailable(queueId);
                }
            }
            return null;
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Void> add(@NotNull String queueId, boolean shared, @NotNull List<PUBLISH> publishes, boolean retained, long queueLimit) {
        try {
            Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
            Preconditions.checkNotNull(publishes, (Object)"Publishes must not be null");
        }
        catch (Exception exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
        return this.singleWriter.submit(queueId, bucketIndex -> {
            boolean queueWasEmpty = this.localPersistence.size(queueId, shared, bucketIndex) == 0;
            this.localPersistence.add(queueId, shared, publishes, queueLimit, this.mqttConfigurationService.getQueuedMessagesStrategy(), retained, bucketIndex);
            if (queueWasEmpty) {
                if (shared) {
                    this.sharedPublishAvailable(queueId);
                } else {
                    this.publishAvailable(queueId);
                }
            }
            return null;
        });
    }

    @Override
    public void publishAvailable(@NotNull String client) {
        ClientSession session = this.clientSessionLocalPersistence.getSession(client);
        if (session == null || !session.isConnected()) {
            return;
        }
        ClientConnection clientConnection = this.connectionPersistence.get(client);
        if (clientConnection == null || !clientConnection.getChannel().isActive()) {
            return;
        }
        if (clientConnection.isMessagesInFlight()) {
            return;
        }
        clientConnection.getChannel().eventLoop().submit(() -> this.publishPollService.pollNewMessages(client, clientConnection.getChannel()));
    }

    @Override
    public void sharedPublishAvailable(@NotNull String sharedSubscription) {
        this.publishPollService.pollSharedPublishes(sharedSubscription);
    }

    @Override
    @NotNull
    public ListenableFuture<ImmutableList<PUBLISH>> readNew(@NotNull String queueId, boolean shared, @NotNull ImmutableIntArray packetIds, long byteLimit) {
        try {
            Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
            Preconditions.checkNotNull((Object)packetIds, (Object)"Message ID's must not be null");
        }
        catch (Exception exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
        return this.singleWriter.submit(queueId, bucketIndex -> this.localPersistence.readNew(queueId, shared, packetIds, byteLimit, bucketIndex));
    }

    @Override
    @NotNull
    public ListenableFuture<ImmutableList<PUBLISH>> readShared(@NotNull String sharedSubscription, int messageLimit, long byteLimit) {
        Preconditions.checkNotNull((Object)sharedSubscription, (Object)"Shared subscription must not be null");
        ImmutableIntArray.Builder builder = ImmutableIntArray.builder((int)messageLimit);
        for (int i = 0; i < messageLimit; ++i) {
            builder.add(1);
        }
        return this.readNew(sharedSubscription, true, builder.build(), byteLimit);
    }

    @Override
    @NotNull
    public ListenableFuture<ImmutableList<MessageWithID>> readInflight(@NotNull String client, long byteLimit, int messageLimit) {
        Preconditions.checkNotNull((Object)client, (Object)"Client ID must not be null");
        return this.singleWriter.submit(client, bucketIndex -> this.localPersistence.readInflight(client, false, messageLimit, byteLimit, bucketIndex));
    }

    @Override
    @NotNull
    public ListenableFuture<Void> remove(@NotNull String client, int packetId) {
        Preconditions.checkNotNull((Object)client, (Object)"Client ID must not be null");
        return this.singleWriter.submit(client, bucketIndex -> {
            this.localPersistence.remove(client, packetId, bucketIndex);
            return null;
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Void> putPubrel(@NotNull String client, int packetId) {
        Preconditions.checkNotNull((Object)client, (Object)"Client must not be null");
        return this.singleWriter.submit(client, bucketIndex -> {
            this.localPersistence.replace(client, new PUBREL(packetId), bucketIndex);
            return null;
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Void> clear(@NotNull String queueId, boolean shared) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be");
        return this.singleWriter.submit(queueId, bucketIndex -> {
            this.localPersistence.clear(queueId, shared, bucketIndex);
            return null;
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Void> closeDB() {
        return this.closeDB(this.localPersistence, this.singleWriter);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> cleanUp(int bucketIndex) {
        return this.singleWriter.submit(bucketIndex, bucketIndex1 -> {
            ImmutableSet<String> sharedQueues = this.localPersistence.cleanUp(bucketIndex1);
            for (String sharedQueue : sharedQueues) {
                SharedSubscriptionService.SharedSubscription sharedSubscription = SharedSubscriptionService.splitTopicAndGroup(sharedQueue);
                ImmutableSet<SubscriberWithQoS> sharedSubscriber = this.topicTree.getSharedSubscriber(sharedSubscription.getShareName(), sharedSubscription.getTopicFilter());
                if (!sharedSubscriber.isEmpty()) continue;
                this.localPersistence.clear(sharedQueue, true, bucketIndex);
            }
            return null;
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Integer> size(@NotNull String queueId, boolean shared) {
        return this.singleWriter.submit(queueId, bucketIndex -> this.localPersistence.size(queueId, shared, bucketIndex));
    }

    @Override
    @NotNull
    public ListenableFuture<Void> removeShared(@NotNull String sharedSubscription, @NotNull String uniqueId) {
        return this.singleWriter.submit(sharedSubscription, bucketIndex -> {
            this.localPersistence.removeShared(sharedSubscription, uniqueId, bucketIndex);
            return null;
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Void> removeInFlightMarker(@NotNull String sharedSubscription, @NotNull String uniqueId) {
        return this.singleWriter.submit(sharedSubscription, bucketIndex -> {
            this.localPersistence.removeInFlightMarker(sharedSubscription, uniqueId, bucketIndex);
            this.sharedPublishAvailable(sharedSubscription);
            return null;
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Void> removeAllQos0Messages(@NotNull String queueId, boolean shared) {
        return this.singleWriter.submit(queueId, bucketIndex -> {
            this.localPersistence.removeAllQos0Messages(queueId, shared, bucketIndex);
            return null;
        });
    }

    public static class Key
    implements Comparable<Key> {
        @NotNull
        private final String queueId;
        private final boolean shared;

        public Key(@NotNull String queueId, boolean shared) {
            this.queueId = queueId;
            this.shared = shared;
        }

        @NotNull
        public String getQueueId() {
            return this.queueId;
        }

        public boolean isShared() {
            return this.shared;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.shared == key.shared && Objects.equals(this.queueId, key.queueId);
        }

        public int hashCode() {
            return Objects.hash(this.queueId, this.shared);
        }

        @Override
        public int compareTo(@NotNull Key other) {
            int compare = this.queueId.compareTo(other.queueId);
            if (compare == 0) {
                compare = Boolean.compare(this.shared, other.shared);
            }
            return compare;
        }
    }
}

