/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc.provider.local;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.persistence.local.xodus.RetainedMessageRocksDBLocalPersistence;
import com.hivemq.persistence.local.xodus.RetainedMessageXodusLocalPersistence;
import com.hivemq.persistence.retained.RetainedMessageLocalPersistence;
import javax.inject.Inject;
import javax.inject.Provider;

@LazySingleton
public class RetainedMessageLocalPersistenceProvider
implements Provider<RetainedMessageLocalPersistence> {
    @NotNull
    private final Provider<RetainedMessageRocksDBLocalPersistence> rocksDBProvider;
    @NotNull
    private final Provider<RetainedMessageXodusLocalPersistence> xodusProvider;
    @NotNull
    private final PersistenceType persistenceType;

    @Inject
    public RetainedMessageLocalPersistenceProvider(@NotNull Provider<RetainedMessageRocksDBLocalPersistence> rocksDBProvider, @NotNull Provider<RetainedMessageXodusLocalPersistence> xodusProvider) {
        this.rocksDBProvider = rocksDBProvider;
        this.xodusProvider = xodusProvider;
        this.persistenceType = InternalConfigurations.RETAINED_MESSAGE_PERSISTENCE_TYPE.get();
    }

    @NotNull
    public RetainedMessageLocalPersistence get() {
        if (this.persistenceType == PersistenceType.FILE_NATIVE) {
            return (RetainedMessageLocalPersistence)this.rocksDBProvider.get();
        }
        return (RetainedMessageLocalPersistence)this.xodusProvider.get();
    }
}

