/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.xodus;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.iteration.BucketChunkResult;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.persistence.local.DeltaCounter;
import com.hivemq.persistence.local.xodus.EnvironmentUtil;
import com.hivemq.persistence.local.xodus.PublishTopicTree;
import com.hivemq.persistence.local.xodus.RetainedMessageSerializer;
import com.hivemq.persistence.local.xodus.XodusLocalPersistence;
import com.hivemq.persistence.local.xodus.XodusUtils;
import com.hivemq.persistence.local.xodus.bucket.Bucket;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.persistence.retained.RetainedMessageLocalPersistence;
import com.hivemq.util.LocalPersistenceFileUtil;
import com.hivemq.util.ThreadPreConditions;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class RetainedMessageXodusLocalPersistence
extends XodusLocalPersistence
implements RetainedMessageLocalPersistence {
    private static final Logger log = LoggerFactory.getLogger(RetainedMessageXodusLocalPersistence.class);
    public static final String PERSISTENCE_VERSION = "040500";
    @NotNull
    private final PublishPayloadPersistence payloadPersistence;
    @NotNull
    private final AtomicLong retainMessageCounter = new AtomicLong(0L);
    @VisibleForTesting
    @NotNull
    final ConcurrentHashMap<Integer, PublishTopicTree> topicTrees = new ConcurrentHashMap();

    @Inject
    public RetainedMessageXodusLocalPersistence(@NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull PublishPayloadPersistence payloadPersistence, @NotNull EnvironmentUtil environmentUtil, @NotNull PersistenceStartup persistenceStartup) {
        super(environmentUtil, localPersistenceFileUtil, persistenceStartup, InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get(), InternalConfigurations.RETAINED_MESSAGE_PERSISTENCE_TYPE.get().equals((Object)PersistenceType.FILE));
        this.payloadPersistence = payloadPersistence;
        for (int i = 0; i < this.bucketCount; ++i) {
            this.topicTrees.put(i, new PublishTopicTree());
        }
    }

    @Override
    @NotNull
    protected String getName() {
        return "retained_messages";
    }

    @Override
    @NotNull
    protected String getVersion() {
        return PERSISTENCE_VERSION;
    }

    @Override
    @NotNull
    protected StoreConfig getStoreConfig() {
        return StoreConfig.WITHOUT_DUPLICATES;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return log;
    }

    @Override
    @PostConstruct
    protected void postConstruct() {
        super.postConstruct();
    }

    @Override
    public void init() {
        try {
            DeltaCounter retainMessageDelta = DeltaCounter.finishWith(this.retainMessageCounter::addAndGet);
            for (int i = 0; i < this.buckets.length; ++i) {
                Bucket bucket = this.buckets[i];
                PublishTopicTree publishTopicTree = this.topicTrees.get(i);
                bucket.getEnvironment().executeInReadonlyTransaction(txn -> {
                    try (Cursor cursor = bucket.getStore().openCursor(txn);){
                        while (cursor.getNext()) {
                            RetainedMessage message = RetainedMessageSerializer.deserializeValue(XodusUtils.byteIterableToBytes(cursor.getValue()));
                            this.payloadPersistence.incrementReferenceCounterOnBootstrap(message.getPublishId());
                            String topic = RetainedMessageSerializer.deserializeKey(XodusUtils.byteIterableToBytes(cursor.getKey()));
                            publishTopicTree.add(topic);
                            retainMessageDelta.increment();
                        }
                    }
                });
            }
            retainMessageDelta.run();
        }
        catch (ExodusException e) {
            log.error("An error occurred while preparing the Retained Message persistence.");
            log.debug("Original Exception:", (Throwable)e);
            throw new UnrecoverableException(false);
        }
    }

    @Override
    public void clear(int bucketIndex) {
        ThreadPreConditions.startsWith("single-writer");
        this.topicTrees.put(bucketIndex, new PublishTopicTree());
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            DeltaCounter retainMessageDelta = DeltaCounter.finishWith(this.retainMessageCounter::addAndGet);
            txn.setCommitHook((Runnable)retainMessageDelta);
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                while (cursor.getNext()) {
                    RetainedMessage message = RetainedMessageSerializer.deserializeValue(XodusUtils.byteIterableToBytes(cursor.getValue()));
                    this.payloadPersistence.decrementReferenceCounter(message.getPublishId());
                    retainMessageDelta.decrement();
                    cursor.deleteCurrent();
                }
            }
        });
    }

    @Override
    public long size() {
        return this.retainMessageCounter.get();
    }

    @Override
    public void remove(@NotNull String topic, int bucketIndex) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            ByteIterable key = XodusUtils.stringToByteIterable(topic);
            ByteIterable byteIterable = bucket.getStore().get(txn, XodusUtils.bytesToByteIterable(RetainedMessageSerializer.serializeKey(topic)));
            if (byteIterable == null) {
                log.trace("Removing retained message for topic {} (no message was stored previously)", (Object)topic);
                return;
            }
            RetainedMessage message = RetainedMessageSerializer.deserializeValue(XodusUtils.byteIterableToBytes(byteIterable));
            log.trace("Removing retained message for topic {}", (Object)topic);
            bucket.getStore().delete(txn, key);
            this.topicTrees.get(bucketIndex).remove(topic);
            this.payloadPersistence.decrementReferenceCounter(message.getPublishId());
            this.retainMessageCounter.decrementAndGet();
        });
    }

    @Override
    @Nullable
    public RetainedMessage get(@NotNull String topic, int bucketIndex) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Bucket bucket = this.buckets[bucketIndex];
        return (RetainedMessage)bucket.getEnvironment().computeInReadonlyTransaction(txn -> {
            ByteIterable byteIterable = bucket.getStore().get(txn, XodusUtils.bytesToByteIterable(RetainedMessageSerializer.serializeKey(topic)));
            if (byteIterable != null) {
                RetainedMessage message = RetainedMessageSerializer.deserializeValue(XodusUtils.byteIterableToBytes(byteIterable));
                if (message.hasExpired()) {
                    return null;
                }
                byte[] payload = this.payloadPersistence.get(message.getPublishId());
                if (payload == null) {
                    log.warn("No payload was found for the retained message on topic {}.", (Object)topic);
                    return null;
                }
                message.setMessage(payload);
                return message;
            }
            return null;
        });
    }

    @Override
    public void put(@NotNull RetainedMessage retainedMessage, @NotNull String topic, int bucketIndex) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkNotNull((Object)retainedMessage, (Object)"Retained message must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                ByteIterable byteIterable = cursor.getSearchKey(XodusUtils.bytesToByteIterable(RetainedMessageSerializer.serializeKey(topic)));
                if (byteIterable != null) {
                    RetainedMessage retainedMessageFromStore = RetainedMessageSerializer.deserializeValue(XodusUtils.byteIterableToBytes(cursor.getValue()));
                    log.trace("Replacing retained message for topic {}", (Object)topic);
                    txn.setCommitHook(() -> {
                        this.payloadPersistence.decrementReferenceCounter(retainedMessageFromStore.getPublishId());
                        this.payloadPersistence.add(retainedMessage.getMessage(), retainedMessage.getPublishId());
                    });
                    bucket.getStore().put(txn, XodusUtils.bytesToByteIterable(RetainedMessageSerializer.serializeKey(topic)), XodusUtils.bytesToByteIterable(RetainedMessageSerializer.serializeValue(retainedMessage)));
                } else {
                    txn.setCommitHook(() -> {
                        this.retainMessageCounter.incrementAndGet();
                        this.topicTrees.get(bucketIndex).add(topic);
                        this.payloadPersistence.add(retainedMessage.getMessage(), retainedMessage.getPublishId());
                    });
                    bucket.getStore().put(txn, XodusUtils.bytesToByteIterable(RetainedMessageSerializer.serializeKey(topic)), XodusUtils.bytesToByteIterable(RetainedMessageSerializer.serializeValue(retainedMessage)));
                    log.trace("Creating new retained message for topic {}", (Object)topic);
                }
            }
        });
    }

    @Override
    @NotNull
    public Set<String> getAllTopics(@NotNull String subscription, int bucketId) {
        Preconditions.checkArgument((bucketId >= 0 && bucketId < this.bucketCount ? 1 : 0) != 0, (Object)"Bucket index out of range");
        ThreadPreConditions.startsWith("single-writer");
        return this.topicTrees.get(bucketId).get(subscription);
    }

    @Override
    public void cleanUp(int bucketId) {
        Preconditions.checkArgument((bucketId >= 0 && bucketId < this.bucketCount ? 1 : 0) != 0, (Object)"Bucket index out of range");
        ThreadPreConditions.startsWith("single-writer");
        if (this.stopped.get()) {
            return;
        }
        Bucket bucket = this.buckets[bucketId];
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                while (cursor.getNext()) {
                    RetainedMessage message = RetainedMessageSerializer.deserializeValue(XodusUtils.byteIterableToBytes(cursor.getValue()));
                    if (!message.hasExpired()) continue;
                    cursor.deleteCurrent();
                    this.payloadPersistence.decrementReferenceCounter(message.getPublishId());
                    this.retainMessageCounter.decrementAndGet();
                    this.topicTrees.get(bucketId).remove(RetainedMessageSerializer.deserializeKey(XodusUtils.byteIterableToBytes(cursor.getKey())));
                }
            }
        });
    }

    @Override
    @NotNull
    public @NotNull BucketChunkResult<Map<String, @NotNull RetainedMessage>> getAllRetainedMessagesChunk(int bucketIndex, @Nullable String lastTopic, int maxMemory) {
        ThreadPreConditions.startsWith("single-writer");
        Bucket bucket = this.buckets[bucketIndex];
        return (BucketChunkResult)bucket.getEnvironment().computeInReadonlyTransaction(txn -> {
            int usedMemory = 0;
            ImmutableMap.Builder retrievedMessages = ImmutableMap.builder();
            String lastFoundTopic = lastTopic;
            boolean hasNext = true;
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                if (lastTopic == null) {
                    hasNext = cursor.getNext();
                } else {
                    ByteIterable lastTopicKey = XodusUtils.bytesToByteIterable(RetainedMessageSerializer.serializeKey(lastFoundTopic));
                    ByteIterable foundKey = cursor.getSearchKeyRange(lastTopicKey);
                    if (foundKey == null) {
                        BucketChunkResult<ImmutableMap> bucketChunkResult = new BucketChunkResult<ImmutableMap>(retrievedMessages.build(), true, lastTopic, bucketIndex);
                        return bucketChunkResult;
                    }
                    if (cursor.getKey().equals(lastTopicKey)) {
                        hasNext = cursor.getNext();
                    }
                }
                while (hasNext && usedMemory < maxMemory) {
                    String deserializedTopic = XodusUtils.byteIterableToString(cursor.getKey());
                    RetainedMessage deserializedMessage = RetainedMessageSerializer.deserializeValue(XodusUtils.byteIterableToBytes(cursor.getValue()));
                    if (deserializedMessage.hasExpired()) {
                        hasNext = cursor.getNext();
                        continue;
                    }
                    byte[] payload = this.payloadPersistence.get(deserializedMessage.getPublishId());
                    if (payload == null) {
                        log.warn("Could not dereference payload for retained message on topic \"{}\" with payload id \"{}\".", (Object)deserializedTopic, (Object)deserializedMessage.getPublishId());
                        hasNext = cursor.getNext();
                        continue;
                    }
                    deserializedMessage.setMessage(payload);
                    lastFoundTopic = deserializedTopic;
                    usedMemory += deserializedMessage.getEstimatedSizeInMemory();
                    retrievedMessages.put((Object)lastFoundTopic, (Object)deserializedMessage);
                    hasNext = cursor.getNext();
                }
            }
            return new BucketChunkResult<ImmutableMap>(retrievedMessages.build(), !hasNext, lastFoundTopic, bucketIndex);
        });
    }

    @Override
    public void iterate(@NotNull RetainedMessageLocalPersistence.ItemCallback callback) {
        ThreadPreConditions.startsWith("single-writer");
        for (Bucket bucket : this.buckets) {
            bucket.getEnvironment().executeInReadonlyTransaction(txn -> {
                try (Cursor cursor = bucket.getStore().openCursor(txn);){
                    while (cursor.getNext()) {
                        RetainedMessage message = RetainedMessageSerializer.deserializeValue(XodusUtils.byteIterableToBytes(cursor.getValue()));
                        String topic = RetainedMessageSerializer.deserializeKey(XodusUtils.byteIterableToBytes(cursor.getKey()));
                        callback.onItem(topic, message);
                    }
                }
            });
        }
    }
}

