/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IntMap
implements Iterable<IntMapEntry> {
    private int[] backingArray = null;

    public IntMap() {
    }

    public IntMap(int initialSize) {
        this.backingArray = new int[initialSize * 2];
        for (int i = 0; i < this.backingArray.length; i += 2) {
            this.backingArray[i] = i;
        }
    }

    public IntMap(IntMap intMap) {
        this.backingArray = (int[])(intMap.backingArray == null ? null : Arrays.copyOf(intMap.backingArray, intMap.backingArray.length));
    }

    public int get(int key) {
        if (this.backingArray == null) {
            return 0;
        }
        for (int i = 0; i < this.backingArray.length; i += 2) {
            if (this.backingArray[i] != key) continue;
            return this.backingArray[i + 1];
        }
        return 0;
    }

    public int put(int key, int value) {
        if (value == 0) {
            return this.remove(key);
        }
        if (this.backingArray == null) {
            this.backingArray = new int[2];
            this.backingArray[0] = key;
            this.backingArray[1] = value;
            return 0;
        }
        for (int i = 0; i < this.backingArray.length; i += 2) {
            if (this.backingArray[i] != key) continue;
            int previousValue = this.backingArray[i + 1];
            this.backingArray[i + 1] = value;
            return previousValue;
        }
        this.growArray();
        this.backingArray[this.backingArray.length - 2] = key;
        this.backingArray[this.backingArray.length - 1] = value;
        return 0;
    }

    public int increment(int key) {
        if (this.backingArray == null) {
            this.backingArray = new int[2];
            this.backingArray[0] = key;
            this.backingArray[1] = 1;
            return 0;
        }
        for (int i = 0; i < this.backingArray.length; i += 2) {
            if (this.backingArray[i] != key) continue;
            int previousValue = this.backingArray[i + 1];
            this.backingArray[i + 1] = this.backingArray[i + 1] + 1;
            return previousValue;
        }
        this.put(key, 1);
        return 0;
    }

    public void putUnsafe(int key, int value, int index) {
        int keyIndex = index * 2;
        this.backingArray[keyIndex] = key;
        this.backingArray[keyIndex + 1] = value;
    }

    public int remove(int key) {
        if (this.backingArray == null) {
            return 0;
        }
        for (int i = 0; i < this.backingArray.length; i += 2) {
            if (this.backingArray[i] != key) continue;
            this.backingArray[i] = this.backingArray[this.backingArray.length - 2];
            int previousValue = this.backingArray[i + 1];
            this.backingArray[i + 1] = this.backingArray[this.backingArray.length - 1];
            this.shrinkArray();
            return previousValue;
        }
        return 0;
    }

    public void mergeMax(IntMap intMap) {
        int[] otherArray = intMap.backingArray;
        if (otherArray == null) {
            return;
        }
        for (int i = 0; i < otherArray.length; i += 2) {
            int otherValue = otherArray[i + 1];
            int key = otherArray[i];
            int currentValue = this.get(key);
            if (otherValue <= currentValue) continue;
            this.put(key, otherValue);
        }
    }

    public int size() {
        if (this.backingArray == null) {
            return 0;
        }
        return this.backingArray.length / 2;
    }

    public boolean isEmpty() {
        if (this.backingArray == null) {
            return true;
        }
        return this.backingArray.length == 0;
    }

    private void shrinkArray() {
        if (this.backingArray == null || this.backingArray.length == 0) {
            return;
        }
        int[] newArray = new int[this.backingArray.length - 2];
        System.arraycopy(this.backingArray, 0, newArray, 0, newArray.length);
        this.backingArray = newArray;
    }

    private void growArray() {
        int[] newArray = new int[this.backingArray.length + 2];
        System.arraycopy(this.backingArray, 0, newArray, 0, this.backingArray.length);
        this.backingArray = newArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntMap that = (IntMap)o;
        return Arrays.equals(this.backingArray, that.backingArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.backingArray);
    }

    @Override
    public Iterator<IntMapEntry> iterator() {
        return new IntMapIterator(this);
    }

    public static class IntMapEntry {
        private final int key;
        private final int value;

        private IntMapEntry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntMapEntry that = (IntMapEntry)o;
            if (this.key != that.key) {
                return false;
            }
            return this.value == that.value;
        }

        public int hashCode() {
            int result = this.key;
            result = 31 * result + this.value;
            return result;
        }
    }

    private static class IntMapIterator
    implements Iterator<IntMapEntry> {
        private final IntMap map;
        private int nextIndex = 0;

        private IntMapIterator(IntMap map) {
            this.map = map;
        }

        @Override
        public boolean hasNext() {
            if (this.map.backingArray == null) {
                return false;
            }
            return this.nextIndex < this.map.backingArray.length;
        }

        @Override
        public IntMapEntry next() {
            if (!this.hasNext()) {
                return null;
            }
            IntMapEntry entry = new IntMapEntry(this.map.backingArray[this.nextIndex], this.map.backingArray[this.nextIndex + 1]);
            this.nextIndex += 2;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

