/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.info.SystemInformation;
import java.io.File;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class LocalPersistenceFileUtil {
    public static final String PERSISTENCE_SUBFOLDER_NAME = "persistence";
    private static final Logger log = LoggerFactory.getLogger(LocalPersistenceFileUtil.class);
    private final SystemInformation systemInformation;

    @Inject
    LocalPersistenceFileUtil(SystemInformation systemInformation) {
        this.systemInformation = systemInformation;
    }

    public synchronized File getLocalPersistenceFolder() {
        File dataFolder = this.systemInformation.getDataFolder();
        File persistenceFolder = new File(dataFolder, PERSISTENCE_SUBFOLDER_NAME);
        if (!persistenceFolder.exists()) {
            log.debug("Folder {} does not exist, trying to create it", (Object)persistenceFolder.getAbsolutePath());
            boolean createdDirectory = persistenceFolder.mkdirs();
            if (createdDirectory) {
                log.debug("Created folder {}", (Object)dataFolder.getAbsolutePath());
            }
        }
        return persistenceFolder;
    }

    public synchronized File getVersionedLocalPersistenceFolder(String persistence, String version) {
        File versionedFolder = new File(this.getLocalPersistenceFolder(), persistence + File.separator + version);
        if (!versionedFolder.exists()) {
            log.debug("Folder {} does not exist, trying to create it", (Object)versionedFolder.getAbsolutePath());
            versionedFolder.mkdirs();
        }
        return versionedFolder;
    }
}

