/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.extension.sdk.api.annotations.Nullable;

public class ObjectMemoryEstimation {
    public static final int OBJECT_SHELL_SIZE = 12;
    public static final int OBJECT_REF_SIZE = 4;
    public static final int ENUM_OVERHEAD = 4;
    public static final int STRING_OVERHEAD = 38;
    public static final int ARRAY_OVERHEAD = 12;
    public static final int COLLECTION_OVERHEAD = 12;
    public static final int LINKED_LIST_NODE_OVERHEAD = 24;
    public static final int LONG_WRAPPER_SIZE = 24;
    public static final int INT_WRAPPER_SIZE = 16;
    public static final int LONG_SIZE = 8;
    public static final int INT_SIZE = 4;
    public static final int CHAR_SIZE = 2;
    public static final int BOOLEAN_SIZE = 1;

    public static int enumSize() {
        return 4;
    }

    public static int stringSize(@Nullable String string) {
        if (string == null) {
            return 0;
        }
        int size = 38;
        return size += string.length() * 2;
    }

    public static int byteArraySize(@Nullable byte[] array) {
        if (array == null) {
            return 0;
        }
        int size = 12;
        return size += array.length;
    }

    public static int immutableIntArraySize(@Nullable ImmutableIntArray array) {
        if (array == null) {
            return 0;
        }
        int size = 12;
        size += ObjectMemoryEstimation.intSize();
        size += ObjectMemoryEstimation.intSize();
        return size += array.length() * 4;
    }

    public static int longWrapperSize() {
        return 24;
    }

    public static int intWrapperSize() {
        return 16;
    }

    public static int longSize() {
        return 8;
    }

    public static int intSize() {
        return 4;
    }

    public static int booleanSize() {
        return 1;
    }

    public static int objectShellSize() {
        return 12;
    }

    public static int objectRefSize() {
        return 4;
    }

    public static int collectionOverhead() {
        return 12;
    }

    public static int linkedListNodeOverhead() {
        return 24;
    }
}

