/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadFactoryUtil {
    @NotNull
    public static ThreadFactory create(@NotNull String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionHandler()).build();
    }

    private static class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private static final Logger log = LoggerFactory.getLogger(UncaughtExceptionHandler.class);

        private UncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(@NotNull Thread thread, @NotNull Throwable throwable) {
            log.error("Uncaught exception in thread '{}'.", (Object)thread.getName(), (Object)throwable);
        }
    }
}

