/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.websocket;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.internal.NetworkModule;
import org.eclipse.paho.mqttv5.client.spi.NetworkModuleFactory;
import org.eclipse.paho.mqttv5.client.websocket.WebSocketNetworkModule;
import org.eclipse.paho.mqttv5.common.ExceptionHelper;
import org.eclipse.paho.mqttv5.common.MqttException;

public class WebSocketNetworkModuleFactory
implements NetworkModuleFactory {
    @Override
    public Set<String> getSupportedUriSchemes() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ws")));
    }

    @Override
    public void validateURI(URI brokerUri) throws IllegalArgumentException {
    }

    @Override
    public NetworkModule createNetworkModule(URI brokerUri, MqttConnectionOptions options, String clientId) throws MqttException {
        SocketFactory factory;
        String host = brokerUri.getHost();
        int port = brokerUri.getPort();
        if (port == -1) {
            port = 80;
        }
        if ((factory = options.getSocketFactory()) == null) {
            factory = SocketFactory.getDefault();
        } else if (factory instanceof SSLSocketFactory) {
            throw ExceptionHelper.createMqttException(32105);
        }
        WebSocketNetworkModule netModule = new WebSocketNetworkModule(factory, brokerUri.toString(), host, port, clientId);
        netModule.setConnectTimeout(options.getConnectionTimeout());
        netModule.setCustomWebSocketHeaders(options.getCustomWebSocketHeaders());
        return netModule;
    }
}

