/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.Invokable;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxOperation;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.lambda.VABLambdaProviderHelper;

public class BaSyxProperty
extends BaSyxSubmodelElement
implements Property {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaSyxOperation.class);
    private ISubmodelElement property;

    private BaSyxProperty() {
    }

    public BaSyxProperty(IProperty property) {
        this.property = property;
    }

    public String getIdShort() {
        try {
            return this.property.getIdShort();
        }
        catch (ResourceNotFoundException e) {
            return "";
        }
    }

    public String getSemanticId(boolean stripPrefix) {
        return Tools.translateReference(this.property.getSemanticId(), stripPrefix);
    }

    public Object getValue() throws ExecutionException {
        try {
            ValueType type = null;
            if (this.property instanceof IProperty) {
                type = ((IProperty)this.property).getValueType();
            }
            return Tools.translateValueFromBaSyx(this.property.getValue(), type);
        }
        catch (ResourceNotFoundException e) {
            throw new ExecutionException(e);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public void setValue(Object value) throws ExecutionException {
        try {
            this.property.setValue(Tools.translateValueToBaSyx(Tools.getType(this.property), value));
        }
        catch (ResourceNotFoundException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    ISubmodelElement getSubmodelElement() {
        return this.property;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitProperty((Property)this);
    }

    public Map<String, LangString> getDescription() {
        return Tools.translate(this.property.getDescription());
    }

    public void setSemanticId(String semanticId) {
        IReference ref = Tools.translateReference(semanticId);
        if (ref != null && this.property instanceof org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property) {
            ((org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property)this.property).setSemanticId(ref);
        }
    }

    public static class BaSyxPropertyBuilder
    implements Property.PropertyBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxProperty instance;
        private org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property property;
        private ValueType typeDef;

        BaSyxPropertyBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort) {
            this.parentBuilder = parentBuilder;
            this.instance = new BaSyxProperty();
            this.property = new org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property();
            this.property.setIdShort(Tools.checkId(idShort));
            this.property.setDescription(new LangStrings());
            this.property.setEmbeddedDataSpecifications(new ArrayList());
        }

        BaSyxPropertyBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, BaSyxProperty instance) {
            this.parentBuilder = parentBuilder;
            this.instance = instance;
            this.property = (org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property)instance.property;
        }

        public BaSyxSubmodelElementContainerBuilder<?> getParentBuilder() {
            return this.parentBuilder;
        }

        public Property.PropertyBuilder setType(Type type) {
            this.typeDef = Tools.translate(type);
            this.property.setValueType(this.typeDef);
            return this;
        }

        public Property.PropertyBuilder bind(Invokable get, Invokable set) {
            if (null == this.typeDef) {
                throw new IllegalArgumentException("setType was not called before");
            }
            if (get != null && !(get instanceof Serializable)) {
                throw new IllegalArgumentException("'get' for " + this.property.getIdShort() + " must be serializable.");
            }
            if (set != null && !(set instanceof Serializable)) {
                throw new IllegalArgumentException("'set' for " + this.property.getIdShort() + " must be serializable.");
            }
            return this.bindLazy(get, set);
        }

        public Property.PropertyBuilder bindLazy(Invokable get, Invokable set) {
            if (null != get && null == set) {
                LOGGER.warn("Creating AAS operation " + this.property.getIdShort() + " with only a bound getter can lead to runtime inconsistencies as setting the value will change the value in the property rather than the value in the underlying representation object.");
            }
            this.property.set((Object)VABLambdaProviderHelper.createSimple((Supplier)(null == get ? null : get.getGetter()), (Consumer)(null == set ? null : set.getSetter())), this.typeDef);
            return this;
        }

        public Property.PropertyBuilder setValue(Type type, Object value) {
            this.setType(type);
            return this.setValue(value);
        }

        public Property.PropertyBuilder setDescription(LangString ... description) {
            this.property.setDescription(Tools.translate(description));
            return this;
        }

        public Property.PropertyBuilder setValue(Object value) {
            this.property.setValue(Tools.translateValueToBaSyx(Tools.getType((ISubmodelElement)this.property), value));
            return this;
        }

        public Property.PropertyBuilder setSemanticId(String refValue) {
            IReference ref = Tools.translateReference(refValue);
            if (ref != null) {
                this.property.setSemanticId(ref);
            }
            return this;
        }

        public Property build() {
            this.instance.property = this.property;
            return null != this.parentBuilder ? this.parentBuilder.register(this.instance) : this.instance;
        }

        public Object getValue() throws ExecutionException {
            return this.property.getValue();
        }

        public Property.PropertyBuilder rbac(AuthenticationDescriptor auth, AuthenticationDescriptor.Role role, AuthenticationDescriptor.RbacAction ... actions) {
            return (Property.PropertyBuilder)AuthenticationDescriptor.elementRbac((Object)this, (AuthenticationDescriptor)auth, (AuthenticationDescriptor.Role)role, (String)this.parentBuilder.composeRbacPath(this.property.getIdShort()), (AuthenticationDescriptor.RbacAction[])actions);
        }
    }
}

