/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.IOUtils;
import de.iip_ecosphere.platform.support.ZipUtils;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonIterator;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Updater {
    private static final String SNAPSHOT = "SNAPSHOT";

    public static void updatePluginsQuiet(InputStream resolved, File pluginsFolder, boolean updatePlugins) {
        try {
            Updater.updatePlugins(resolved, pluginsFolder, updatePlugins);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Updater.class).warn("During plugins/dependency update: {}", (Object)e.getMessage());
        }
    }

    public static void updatePlugins(InputStream resolved, File pluginsFolder, boolean updatePlugins) throws IOException {
        if (null == resolved) {
            throw new IOException("No \"resolved\" input stream given.");
        }
        String json = IOUtils.toString((InputStream)resolved);
        JsonIterator it = Json.parse((String)json);
        for (int i = 0; i < it.size(); ++i) {
            String type;
            JsonIterator eIt = it.get(i);
            String url = eIt.get("url").toStringValue();
            if (url.startsWith("./") || url.startsWith(".\\")) {
                url = url.substring(2);
                url = new File(url).toURI().toURL().toString();
            }
            String name = eIt.get("name").toStringValue();
            boolean plugin = eIt.get("plugin").toBooleanValue();
            File pluginFile = new File(pluginsFolder, name);
            String string = type = plugin ? "plugin" : "dependency";
            if (pluginFile.exists() && (!name.endsWith(SNAPSHOT) || !updatePlugins)) continue;
            LoggerFactory.getLogger(Updater.class).info("Resolving {} {}", (Object)type, (Object)name);
            File metadataFile = new File(pluginsFolder, ".metadata");
            Properties metadata = new Properties();
            try {
                metadata.load(new FileInputStream(metadataFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            PluginResolutionResult res = Updater.resolvePlugin(name, url, metadata.get(name));
            if (null == res || null == res.stream) continue;
            LoggerFactory.getLogger(Updater.class).info("Updating {} {}", (Object)type, (Object)name);
            String fName = name + (plugin ? ".zip" : ".jar");
            File targetFile = new File(pluginsFolder, fName);
            FileUtils.copyInputStreamToFile((InputStream)res.stream, (File)targetFile);
            FileUtils.closeQuietly((Closeable)res.stream);
            if (plugin) {
                Updater.unzipPlugin(targetFile, name);
            }
            if (!res.hasBuildNr()) continue;
            metadata.put(name, res.buildNr);
            try {
                metadata.store(new FileOutputStream(metadataFile), name);
                continue;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(Updater.class).warn("Cannot write {} metadata file {}: {}", new Object[]{type, metadataFile, e.getMessage()});
            }
        }
    }

    private static void unzipPlugin(File file, String name) throws IOException {
        File pluginDir = file.getParentFile();
        ZipUtils.extractZip((InputStream)new FileInputStream(file), (Path)pluginDir.toPath(), e -> !e.getName().equals("resolved"));
        File cp = new File(pluginDir, "classpath");
        File cpTarget = new File(pluginDir, name);
        FileUtils.deleteQuietly((File)cpTarget);
        cp.renameTo(cpTarget);
        FileUtils.deleteQuietly((File)file);
    }

    private static PluginResolutionResult resolvePlugin(String pluginName, String pluginUrl, Object lastBuildNr) {
        PluginResolutionResult result = null;
        try {
            URL url = new URL(pluginUrl);
            try {
                result = new PluginResolutionResult(url.openStream());
            }
            catch (IOException e) {
                result = Updater.resolvePluginWithMaven(pluginName, pluginUrl, lastBuildNr);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    private static PluginResolutionResult resolvePluginWithMaven(String pluginName, String pluginUrl, Object lastBuildNr) throws MalformedURLException {
        int pos;
        PluginResolutionResult result = null;
        if (pluginName.endsWith(SNAPSHOT) && (pos = pluginUrl.lastIndexOf("/")) > 0) {
            String base = pluginUrl.substring(0, pos + 1);
            String name = pluginUrl.substring(pos + 1);
            URL url = new URL(base + "maven-metadata.xml");
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(url.openStream());
                Node versioning = Updater.getElement(doc.getDocumentElement().getChildNodes(), "versioning");
                Node snapshot = Updater.getElement(versioning, "snapshot");
                Node timestamp = Updater.getElement(snapshot, "timestamp");
                Node buildNr = Updater.getElement(snapshot, "buildNumber");
                if (timestamp != null && buildNr != null) {
                    int startPos;
                    int endPos = name.lastIndexOf(".");
                    if (endPos > 0) {
                        endPos = name.lastIndexOf("-", endPos - 1);
                    }
                    if ((startPos = endPos) > 0) {
                        startPos = name.lastIndexOf("-", startPos - 1);
                    }
                    if (startPos > 0) {
                        startPos = name.lastIndexOf("-", startPos - 1);
                    }
                    String buildNrText = buildNr.getTextContent().trim();
                    if (startPos != endPos && Updater.isMoreRecent(lastBuildNr, buildNrText)) {
                        name = name.substring(0, startPos + 1) + timestamp.getTextContent().trim() + "-" + buildNrText + name.substring(endPos);
                        try {
                            url = new URL(base + name);
                            result = new PluginResolutionResult(url.openStream(), buildNrText);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean isMoreRecent(Object lastBuildNr, String buildNr) {
        boolean isMoreRecent = true;
        if (lastBuildNr != null) {
            try {
                int last = Integer.parseInt(lastBuildNr.toString());
                int actual = Integer.parseInt(buildNr);
                isMoreRecent = actual > last;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isMoreRecent;
    }

    private static Node getElement(Node node, String name) {
        if (null != node) {
            return Updater.getElement(node.getChildNodes(), name);
        }
        return null;
    }

    private static Node getElement(NodeList list, String name) {
        if (null != list) {
            for (int n = 0; n < list.getLength(); ++n) {
                Node no = list.item(n);
                if (!no.getNodeName().equals(name)) continue;
                return no;
            }
        }
        return null;
    }

    private static class PluginResolutionResult {
        private InputStream stream;
        private String buildNr;

        private PluginResolutionResult(InputStream stream) {
            this(stream, (String)null);
        }

        private PluginResolutionResult(InputStream stream, String buildNr) {
            this.stream = stream;
            this.buildNr = buildNr;
        }

        private boolean hasBuildNr() {
            return this.buildNr != null && this.buildNr.length() > 0;
        }
    }
}

