/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.setup;

import java.util.ArrayList;
import java.util.List;

public class CmdLine {
    public static final String PARAM_PREFIX = "--";
    public static final String PARAM_ARG_NAME_SEP = ".";
    public static final String PARAM_VALUE_SEP = "=";

    public static void parseToArgs(String text, List<String> cmds) {
        CmdLine.parseToArgs(text, cmds, ' ');
    }

    public static void parseToArgs(String text, List<String> cmds, char separator) {
        boolean inQuote = false;
        text = text.trim();
        int lastStart = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if ('\"' == c) {
                boolean bl = inQuote = !inQuote;
            }
            if ((separator != c || inQuote) && i + 1 != text.length()) continue;
            String cmd = text.substring(lastStart, i + 1).trim();
            if (cmd.length() > 0) {
                cmds.add(cmd);
            }
            lastStart = i + 1;
        }
    }

    public static String getArg(String[] args, String argName, String dflt) {
        String result = dflt;
        String prefix = PARAM_PREFIX + argName + PARAM_VALUE_SEP;
        for (int a = 0; a < args.length; ++a) {
            String arg = args[a];
            if (!arg.startsWith(prefix)) continue;
            result = arg.substring(prefix.length());
            break;
        }
        return result;
    }

    public static int getIntArg(String[] args, String argName, int dflt) {
        int result;
        try {
            result = Integer.parseInt(CmdLine.getArg(args, argName, String.valueOf(dflt)));
        }
        catch (NumberFormatException e) {
            result = dflt;
        }
        return result;
    }

    public static boolean getBooleanArg(String[] args, String argName, boolean dflt) {
        return Boolean.valueOf(CmdLine.getArg(args, argName, String.valueOf(dflt)));
    }

    public static String[] toArgs(String args) {
        String tmp;
        if (args == null) {
            args = "";
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean inQuote = false;
        int lastPos = 0;
        for (int i = 0; i < args.length(); ++i) {
            String tmp2;
            char c = args.charAt(i);
            if ('\'' == c || '\"' == c) {
                inQuote = !inQuote;
                continue;
            }
            if (' ' != c || inQuote) continue;
            if (lastPos != i && (tmp2 = args.substring(lastPos, i).trim()).length() > 0) {
                result.add(tmp2);
            }
            lastPos = i + 1;
        }
        if (lastPos < args.length() && (tmp = args.substring(lastPos, args.length()).trim()).length() > 0) {
            result.add(tmp);
        }
        return result.toArray(new String[0]);
    }

    public static String composeArgument(String name, Object value) {
        return PARAM_PREFIX + name + PARAM_VALUE_SEP + value.toString();
    }

    public static boolean hasArgument(String[] args, String argName, boolean includeNoValueArg, boolean includeValueArg) {
        boolean found = false;
        String noValueArg = PARAM_PREFIX + argName;
        String argPrefix = noValueArg + PARAM_VALUE_SEP;
        for (int i = 0; !found && i < args.length; ++i) {
            found = includeNoValueArg && args[i].equals(noValueArg) || includeValueArg && args[i].startsWith(argPrefix);
        }
        return found;
    }

    public static boolean getBooleanArgNoVal(String[] args, String argName, boolean dflt) {
        return CmdLine.getBooleanArg(args, argName, false) || CmdLine.hasArgument(args, argName, true, false);
    }

    public static String[] extractArgNames(String[] args) {
        ArrayList<String> names = new ArrayList<String>();
        for (String a : args) {
            if (!a.startsWith(PARAM_PREFIX)) continue;
            int pos = (a = a.substring(2)).indexOf(PARAM_VALUE_SEP);
            if (pos > 0) {
                a = a.substring(0, pos);
            }
            names.add(a);
        }
        return names.toArray(new String[names.size()]);
    }
}

