/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.tools.lib.loader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class LoaderIndex
implements Serializable {
    private static final long serialVersionUID = -3350988607004003802L;
    private Map<String, String> locationIndex = new HashMap<String, String>();
    private Map<String, String> classIndex = new HashMap<String, String>();
    private Map<String, String> resourceIndex = new HashMap<String, String>();

    public static LoaderIndex createIndex(List<Path> jars) throws IOException {
        return LoaderIndex.addToIndex(new LoaderIndex(), jars);
    }

    public static LoaderIndex addToIndex(LoaderIndex index, List<Path> jars) throws IOException {
        for (Path jarPath : jars) {
            LoaderIndex.addToIndex(index, jarPath.toFile(), null);
        }
        return index;
    }

    public static void addToIndex(LoaderIndex index, File jarFile, String location) throws IOException {
        if (null == location || location.length() == 0) {
            location = jarFile.toString();
        }
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) continue;
                if (name.endsWith(".class")) {
                    String className = name.replace('/', '.').replaceAll("\\.class$", "");
                    LoaderIndex.addToIndex(index, index.classIndex, className, location);
                    continue;
                }
                LoaderIndex.addToIndex(index, index.classIndex, name, location);
            }
        }
    }

    private static void addToIndex(LoaderIndex index, Map<String, String> map, String name, String location) {
        String loc = index.locationIndex.get(location);
        if (null == loc) {
            loc = String.valueOf(index.locationIndex.size());
            index.locationIndex.put(loc, location);
        }
        map.put(name, loc);
    }

    public static void relocateIndex(LoaderIndex index, String prefix, String replacement) {
        LoaderIndex.relocateIndex(index.classIndex, prefix, replacement);
        LoaderIndex.relocateIndex(index.resourceIndex, prefix, replacement);
    }

    private static void relocateIndex(Map<String, String> index, String prefix, String replacement) {
        for (Map.Entry<String, String> entry : index.entrySet()) {
            String path = entry.getValue();
            if (!path.startsWith(prefix)) continue;
            entry.setValue(replacement + path.substring(prefix.length()));
        }
    }

    public static LoaderIndex fromFile(File indexFile) throws IOException {
        LoaderIndex loaderIndex;
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(indexFile)));
        try {
            loaderIndex = (LoaderIndex)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        ois.close();
        return loaderIndex;
    }

    public static void toFile(LoaderIndex index, File file) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            oos.writeObject(index);
        }
    }

    public static void addToIndex(LoaderIndex index, boolean isClass, String name, String location) {
        String loc = index.locationIndex.get(location);
        if (null == loc) {
            loc = String.valueOf(index.locationIndex.size());
            index.locationIndex.put(loc, location);
        }
        Map<String, String> map = isClass ? index.classIndex : index.resourceIndex;
        map.put(name, loc);
    }

    Map<String, String> getLocationIndex() {
        return this.locationIndex;
    }

    Map<String, String> getClassIndex() {
        return this.classIndex;
    }

    Map<String, String> getResourceIndex() {
        return this.resourceIndex;
    }
}

