/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.retriever;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.query.engine.retriever.ConfiguredObjectRetriever;
import org.apache.qpid.server.query.engine.retriever.EntityRetriever;
import org.apache.qpid.server.security.CertificateDetails;

public class CertificateRetriever<C extends ConfiguredObject<?>>
extends ConfiguredObjectRetriever<C>
implements EntityRetriever<C> {
    private final Class<C> _keyStoreType = KeyStore.class;
    private final Class<C> _trustStoreType = TrustStore.class;
    private final List<String> _fieldNames = new ImmutableList.Builder().add((Object)"store").add((Object)"alias").add((Object)"issuerName").add((Object)"serialNumber").add((Object)"hexSerialNumber").add((Object)"signatureAlgorithm").add((Object)"subjectAltNames").add((Object)"subjectName").add((Object)"validFrom").add((Object)"validUntil").add((Object)"version").build();
    private final BiFunction<ConfiguredObject<?>, CertificateDetails, Map<String, Object>> certificateMapping = (parent, certificate) -> ImmutableMap.builder().put((Object)this._fieldNames.get(0), (Object)parent.getName()).put((Object)this._fieldNames.get(1), (Object)certificate.getAlias()).put((Object)this._fieldNames.get(2), (Object)certificate.getIssuerName()).put((Object)this._fieldNames.get(3), (Object)certificate.getSerialNumber()).put((Object)this._fieldNames.get(4), (Object)this.toHex(certificate.getSerialNumber())).put((Object)this._fieldNames.get(5), (Object)certificate.getSignatureAlgorithm()).put((Object)this._fieldNames.get(6), (Object)certificate.getSubjectAltNames()).put((Object)this._fieldNames.get(7), (Object)certificate.getSubjectName()).put((Object)this._fieldNames.get(8), (Object)certificate.getValidFrom()).put((Object)this._fieldNames.get(9), (Object)certificate.getValidUntil()).put((Object)this._fieldNames.get(10), (Object)certificate.getVersion()).build();

    @Override
    public Stream<Map<String, ?>> retrieve(C broker) {
        Stream<KeyStore> keyStoreStream = this.retrieve(broker, this._keyStoreType).map(keystore -> (KeyStore)keystore);
        Stream<TrustStore> trustStoreStream = this.retrieve(broker, this._trustStoreType).map(truststore -> (TrustStore)truststore);
        return Stream.concat(keyStoreStream.flatMap(keyStore -> keyStore.getCertificateDetails().stream().map(certificate -> this.certificateMapping.apply((ConfiguredObject<?>)keyStore, (CertificateDetails)certificate))), trustStoreStream.flatMap(trustStore -> trustStore.getCertificateDetails().stream().map(certificate -> this.certificateMapping.apply((ConfiguredObject<?>)trustStore, (CertificateDetails)certificate))));
    }

    @Override
    public List<String> getFieldNames() {
        return this._fieldNames;
    }

    private String toHex(String serialNumber) {
        try {
            if (serialNumber.contains(":")) {
                return this.format(new BigInteger(serialNumber.replace(":", ""), 16));
            }
            return this.format(new BigInteger(serialNumber));
        }
        catch (NumberFormatException e) {
            return serialNumber;
        }
    }

    private String format(BigInteger serialNumber) {
        return "0x" + serialNumber.toString(16);
    }
}

