/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.plugins;

import de.iip_ecosphere.platform.support.IOUtils;
import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.CurrentClassloaderPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.CurrentContextPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.FolderClasspathPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.IdentifyingClassloader;
import de.iip_ecosphere.platform.support.plugins.Plugin;
import de.iip_ecosphere.platform.support.plugins.PluginBasedSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginInstanceDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginSetup;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class PluginManager {
    public static final String POSTFIX_ID_DEFAULT = "-default";
    public static final String KEY_SETUP_DESCRIPTOR = "# setupDescriptor: ";
    public static final String KEY_SEQUENCE_NR = "# sequenceNr: ";
    public static final String KEY_PLUGIN_IDS = "# pluginIds: ";
    public static final String FILE_PLUGINS_PROPERTY = "okto.plugins";
    private static Map<String, Plugin<?>> plugins = new HashMap();
    private static Map<Class<?>, List<Plugin<?>>> pluginsByType = new HashMap();
    private static Map<String, PluginDescriptor<?>> descriptors = new HashMap();
    private static Predicate<File> pluginCpFilter = f -> true;

    public static Plugin<?> getPlugin(String id) {
        return id == null ? null : plugins.get(id);
    }

    public static <T> Plugin<T> getPlugin(String id, Class<T> cls) {
        Plugin<?> result = null;
        Plugin<?> tmp = PluginManager.getPlugin(id);
        if (null != tmp && cls.isAssignableFrom(tmp.getInstanceClass())) {
            result = tmp;
        } else if (tmp != null) {
            LoggerFactory.getLogger(PluginManager.class).warn("Plugin for id '{}' found, but not compatible with {}", (Object)id, (Object)cls);
        }
        return result;
    }

    public static <T> Plugin<T> getPlugin(Class<T> cls) {
        return PluginManager.getPlugin(cls, null);
    }

    public static <T, I extends PluginInstanceDescriptor<T>> T getPluginInstance(Class<T> pluginCls, Class<I> iCls) {
        Optional<I> svc;
        T result = null;
        Plugin<T> plugin = PluginManager.getPlugin(pluginCls);
        if (null != plugin) {
            result = plugin.getInstance();
        } else if (iCls != null && (svc = ServiceLoaderUtils.filterExcluded(iCls)).isPresent()) {
            result = ((PluginInstanceDescriptor)svc.get()).create();
        }
        return result;
    }

    public static <T> Plugin<T> getPlugin(Class<T> cls, String id) {
        List<Plugin<?>> pls;
        Plugin<?> result = null;
        if (null != cls && null != (pls = pluginsByType.get(cls)) && pls.size() > 0) {
            Plugin<?> tmp = null;
            for (Plugin<?> p : pls) {
                if (!p.getAllIds().contains(id)) continue;
                tmp = p;
                break;
            }
            if (tmp == null) {
                tmp = pls.get(0);
            }
            if (null != tmp && cls.isAssignableFrom(tmp.getInstanceClass())) {
                result = tmp;
            } else if (tmp != null) {
                LoggerFactory.getLogger(PluginManager.class).warn("Plugin for type '{}' found, but not compatible with {}", (Object)cls.getName(), (Object)cls);
            }
        }
        return result;
    }

    public static Iterable<Plugin<?>> plugins() {
        return plugins.values();
    }

    public static void loadPlugins() {
        PluginManager.loadPlugins(true);
    }

    public static void cleanup() {
        for (Plugin<?> d : plugins.values()) {
            d.cleanup();
        }
    }

    private static void loadPlugins(boolean onlyNew) {
        ServiceLoaderUtils.stream(ServiceLoaderUtils.load(PluginSetupDescriptor.class)).forEach(d -> PluginManager.registerPlugin(d, onlyNew));
        String plugins = OsUtils.getPropertyOrEnv(FILE_PLUGINS_PROPERTY, "");
        StringTokenizer tokens = new StringTokenizer(plugins, ":;");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            File file = new File(token);
            if (file.exists() && file.isDirectory()) {
                PluginManager.registerPlugin(new FolderClasspathPluginSetupDescriptor(file), onlyNew);
                continue;
            }
            LoggerFactory.getLogger(PluginManager.class).warn("While reading unpacked plugins from -D{}, {} does not exist/is no directory.", (Object)FILE_PLUGINS_PROPERTY, (Object)file);
        }
    }

    public static void registerPlugin(PluginSetupDescriptor desc) {
        PluginManager.registerPlugin(desc, false);
    }

    private static void registerPlugin(PluginSetupDescriptor desc, boolean onlyNew) {
        LoggerFactory.getLogger(PluginManager.class).info("Found plugin setup descriptor {}. Registering plugin...", (Object)desc.getClass());
        boolean allowAll = !desc.preventDuplicates();
        ClassLoader loader = PluginSetup.getClassLoader();
        ClassLoader descLoader = desc.createClassLoader(loader);
        desc.getPluginDescriptors(descLoader).filter(d -> allowAll || PluginManager.loadedBy(d, descLoader)).forEach(d -> PluginManager.registerPlugin(d, onlyNew, desc.getInstallDir()));
    }

    private static boolean loadedBy(Object obj, ClassLoader loader) {
        IdentifyingClassloader cfLoader;
        boolean found = false;
        IdentifyingClassloader identifyingClassloader = cfLoader = loader instanceof IdentifyingClassloader ? (IdentifyingClassloader)((Object)loader) : null;
        for (ClassLoader iter = obj.getClass().getClassLoader(); iter != null && !found; iter = iter.getParent()) {
            found = null != cfLoader ? cfLoader.amI(iter) : iter == loader;
        }
        return found;
    }

    public static void registerPlugin(PluginDescriptor<?> desc) {
        PluginManager.registerPlugin(desc, true, null);
    }

    public static void registerPlugin(PluginDescriptor<?> desc, boolean onlyNew, File installDir) {
        Plugin<?> known;
        Plugin<?> plugin = desc.createPlugin(installDir);
        Class<?> pluginClass = plugin.getInstanceClass();
        List<String> ids = plugin.getAllIds();
        boolean dflt = ids.stream().anyMatch(i -> i.endsWith(POSTFIX_ID_DEFAULT));
        boolean isKnown = false;
        for (String id : ids) {
            known = plugins.get(id);
            if (null == known) continue;
            if (descriptors.get(id) != desc) {
                LoggerFactory.getLogger(PluginManager.class).warn("Plugin id '{}' is already registered for {}. Ignoring descriptor {}.", id, known.getClass(), desc.getClass());
            }
            isKnown = true;
        }
        if (onlyNew && !isKnown || !onlyNew) {
            for (String id : ids) {
                known = plugins.get(id);
                if (null != known) continue;
                plugins.put(id, plugin);
                descriptors.put(id, desc);
                LoggerFactory.getLogger(PluginManager.class).info("Plugin {} registered", (Object)id);
            }
            List<Plugin<?>> pls = pluginsByType.get(pluginClass);
            if (null == pls) {
                pls = new ArrayList();
                pluginsByType.put(pluginClass, pls);
            }
            if (dflt) {
                pls.add(0, plugin);
            } else {
                pls.add(plugin);
            }
        }
    }

    public static ClassLoader getPluginLoader(String id) {
        return PluginManager.getPluginLoader(id, Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getPluginLoader(String id, ClassLoader dflt) {
        PluginDescriptor<?> desc;
        ClassLoader result = dflt;
        if (null != id && null != (desc = descriptors.get(id))) {
            result = desc.getClass().getClassLoader();
        }
        return result;
    }

    public static void loadAllFrom(File folder, PluginSetupDescriptor ... local) {
        PluginManager.loadAllFrom(folder, null, local);
    }

    public static void loadAllFrom(File folder, PluginFilter filter, PluginSetupDescriptor ... local) {
        File[] files;
        long startTime = System.currentTimeMillis();
        for (File f : files = folder.listFiles()) {
            File cpFile = null;
            if (f.isDirectory()) {
                cpFile = new File(f, "classpath");
            } else if (!f.getName().endsWith("-win") && !f.getName().endsWith("-linux")) {
                cpFile = f;
            }
            if (null == cpFile || !pluginCpFilter.test(cpFile)) continue;
            if (!cpFile.exists()) {
                LoggerFactory.getLogger(PluginManager.class).warn("No plugin classpath file {}. Ignoring.", (Object)cpFile);
                continue;
            }
            PluginManager.loadPluginFrom(cpFile, files.length, filter, local);
        }
        LoggerFactory.getLogger(PluginManager.class).info("Plugin loading completed in {} ms. ", (Object)(System.currentTimeMillis() - startTime));
    }

    public static Predicate<File> setPluginClasspathFilter(Predicate<File> filter) {
        Predicate<File> result = pluginCpFilter;
        if (filter != null) {
            pluginCpFilter = filter;
        }
        return result;
    }

    private static String extractSuffix(String prefix, String line, String dflt) {
        String result = dflt;
        if (null != prefix && line.startsWith(prefix)) {
            result = line.substring(prefix.length()).trim();
        }
        return result;
    }

    private static void addToLoad(List<PluginInfo> toLoad, File cpFile, int sequenceNr, Supplier<PluginSetupDescriptor> supplier) {
        PluginManager.addToLoad(toLoad, cpFile, sequenceNr, supplier, null);
    }

    private static void addToLoad(List<PluginInfo> toLoad, File cpFile, int sequenceNr, Supplier<PluginSetupDescriptor> supplier, List<String> pluginIds) {
        if (null != supplier) {
            toLoad.add(new PluginInfo(cpFile, supplier, sequenceNr, pluginIds));
        }
    }

    private static int parseSequenceNr(File cpFile, String text, int dflt) {
        int result = dflt;
        if (null != text) {
            try {
                result = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(PluginManager.class).warn("Sequence number of plugin {} is not a number ({}). Using {}.", cpFile, e.getMessage(), dflt);
            }
        }
        return result;
    }

    private static void loadPluginFrom(File cpFile, int maxFiles, PluginFilter filter, PluginSetupDescriptor ... local) {
        ArrayList<PluginInfo> toLoad = new ArrayList<PluginInfo>();
        int seqNr = maxFiles + 1;
        try (FileInputStream fis = new FileInputStream(cpFile);){
            List<String> lines = IOUtils.readLines(fis, Charset.defaultCharset());
            String setupDescriptor = null;
            String pluginIds = null;
            String sequenceNr = null;
            for (String line : lines) {
                setupDescriptor = PluginManager.extractSuffix(KEY_SETUP_DESCRIPTOR, line, setupDescriptor);
                pluginIds = PluginManager.extractSuffix(KEY_PLUGIN_IDS, line, pluginIds);
                sequenceNr = PluginManager.extractSuffix(KEY_SEQUENCE_NR, line, sequenceNr);
            }
            setupDescriptor = setupDescriptor == null ? "FolderClasspath" : setupDescriptor;
            setupDescriptor = setupDescriptor.toLowerCase();
            pluginIds = pluginIds == null ? "" : pluginIds;
            int pSeqNr = PluginManager.parseSequenceNr(cpFile, sequenceNr, seqNr);
            switch (setupDescriptor) {
                case "folderclasspath": {
                    PluginManager.addToLoad(toLoad, cpFile, pSeqNr, () -> new FolderClasspathPluginSetupDescriptor(cpFile));
                    break;
                }
                case "currentcontext": {
                    PluginManager.addToLoad(toLoad, cpFile, pSeqNr, () -> CurrentContextPluginSetupDescriptor.INSTANCE);
                    break;
                }
                case "currentclassloader": {
                    PluginManager.addToLoad(toLoad, cpFile, pSeqNr, () -> CurrentClassloaderPluginSetupDescriptor.INSTANCE);
                    break;
                }
                case "pluginbased": {
                    StringTokenizer plIds = new StringTokenizer(pluginIds, ",");
                    ArrayList<String> ids = new ArrayList<String>();
                    while (plIds.hasMoreTokens()) {
                        ids.add(plIds.nextToken().trim());
                    }
                    String plId = ids.size() > 0 ? (String)ids.get(0) : "";
                    PluginManager.addToLoad(toLoad, cpFile, pSeqNr, () -> new PluginBasedSetupDescriptor(plId), ids);
                    break;
                }
                case "process": {
                    PluginManager.addToLoad(toLoad, cpFile, pSeqNr, () -> new FolderClasspathPluginSetupDescriptor(cpFile, true, new File[0]));
                    break;
                }
                case "": 
                case "none": {
                    break;
                }
                default: {
                    try {
                        Class<?> cls = Class.forName(setupDescriptor);
                        Object inst = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (inst instanceof PluginSetupDescriptor) {
                            PluginManager.addToLoad(toLoad, cpFile, pSeqNr, () -> (PluginSetupDescriptor)inst);
                            break;
                        }
                        LoggerFactory.getLogger(PluginManager.class).warn("Plugin setup descriptor for plugin {} is not instanceof PluginSetupDescriptor. Ignoring. Reason: {}", (Object)cpFile);
                        break;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        LoggerFactory.getLogger(PluginManager.class).warn("Cannot determine plugin setup descriptor for plugin classpath file {}. Ignoring. Reason: {}", (Object)cpFile, (Object)e.getMessage());
                    }
                }
            }
            ++seqNr;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(PluginManager.class).warn("Cannot load plugin classpath file {}. Ignoring. Reason: {}", (Object)cpFile, (Object)e.getMessage());
        }
        if (null != filter) {
            toLoad.removeIf(i -> !filter.accept((PluginInfo)i));
        }
        PluginManager.sortPlugins(toLoad);
        for (PluginSetupDescriptor l : local) {
            toLoad.add(0, new PluginInfo(() -> l));
        }
        for (PluginInfo info : toLoad) {
            PluginManager.registerPlugin((PluginSetupDescriptor)info.supplier.get());
        }
    }

    private static List<PluginInfo> sortPlugins(List<PluginInfo> infos) {
        Collections.sort(infos, (i1, i2) -> Integer.compare(i1.getSequenceNr(), i2.getSequenceNr()));
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        ArrayList<PluginInfo> secondary = new ArrayList<PluginInfo>();
        for (PluginInfo info : infos) {
            if (info.hasPluginIds()) {
                secondary.add(info);
                continue;
            }
            result.add(info);
        }
        int beforeSize = -1;
        while (!secondary.isEmpty() && beforeSize != secondary.size()) {
            int tmpBeforeSize = secondary.size();
            for (int s = secondary.size() - 1; s >= 0; --s) {
                PluginInfo info = (PluginInfo)secondary.get(s);
                List infoPluginIds = info.pluginIds;
                int foundCount = 1;
                int insertPos = -1;
                for (int r = 0; r < result.size() && foundCount < infoPluginIds.size(); ++r) {
                    if (!infoPluginIds.contains(((PluginInfo)result.get(r)).getName())) continue;
                    ++foundCount;
                    insertPos = r;
                }
                if (foundCount != infoPluginIds.size()) continue;
                result.add(insertPos, (PluginInfo)secondary.remove(s));
            }
            beforeSize = tmpBeforeSize;
        }
        result.addAll(secondary);
        return result;
    }

    public static interface PluginFilter {
        public boolean accept(PluginInfo var1);
    }

    public static class PluginInfo {
        private int sequenceNr;
        private File file;
        private Supplier<PluginSetupDescriptor> supplier = null;
        private List<String> pluginIds;

        private PluginInfo(Supplier<PluginSetupDescriptor> supplier) {
            this(null, supplier, Integer.MIN_VALUE, null);
        }

        public PluginInfo(File file, Supplier<PluginSetupDescriptor> supplier, int sequenceNr, List<String> pluginIds) {
            this.file = file;
            this.supplier = supplier;
            this.sequenceNr = sequenceNr;
            this.pluginIds = pluginIds;
        }

        public String getName() {
            return null == this.file ? "" : this.file.getName();
        }

        public int getSequenceNr() {
            return this.sequenceNr;
        }

        public boolean hasPluginIds() {
            return this.pluginIds != null && this.pluginIds.size() > 0;
        }
    }

    public static class ConjunctivePluginFilter
    implements PluginFilter {
        private PluginFilter[] filters;

        public ConjunctivePluginFilter(PluginFilter ... filters) {
            this.filters = filters;
        }

        @Override
        public boolean accept(PluginInfo info) {
            boolean accept = true;
            for (int f = 0; accept && f < this.filters.length; accept &= this.filters[f].accept(info), ++f) {
            }
            return accept;
        }
    }
}

