/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.configuration;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.basyx.components.aas.configuration.AASEventBackend;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.configuration.exception.AuthorizationConfigurationException;
import org.eclipse.basyx.vab.protocol.http.connector.IAuthorizationSupplier;
import org.eclipse.basyx.vab.protocol.http.connector.OAuth2ClientCredentialsBasedAuthorizationSupplier;

public class BaSyxAASServerConfiguration
extends BaSyxConfiguration {
    public static final String ENV_PREFIX = "BaSyxAAS_";
    private static final String FEATURE_ENABLED = "Enabled";
    private static final String FEATURE_DISABLED = "Disabled";
    public static final String DEFAULT_BACKEND = AASServerBackend.INMEMORY.toString();
    public static final String DEFAULT_HOSTPATH = "";
    public static final String DEFAULT_SUBMODELS = "[]";
    public static final String DEFAULT_SOURCE = "";
    public static final String DEFAULT_REGISTRY = "";
    public static final String DEFAULT_EVENTS = AASEventBackend.NONE.toString();
    public static final String DEFAULT_AASX_UPLOAD = "Enabled";
    public static final String DEFAULT_AUTHORIZATION = "Disabled";
    public static final String DEFAULT_TOKEN_ENDPOINT = "";
    public static final String DEFAULT_CLIENT_ID = "";
    public static final String DEFAULT_CLIENT_SECRET = "";
    public static final String DEFAULT_CLIENT_SCOPES = "[]";
    public static final String DEFAULT_PROPERTY_DELEGATION = "Enabled";
    public static final String REGISTRY = "registry.path";
    public static final String HOSTPATH = "registry.host";
    public static final String SUBMODELS = "registry.submodels";
    public static final String ID = "aas.id";
    public static final String BACKEND = "aas.backend";
    public static final String SOURCE = "aas.source";
    public static final String EVENTS = "aas.events";
    public static final String AASX_UPLOAD = "aas.aasxUpload";
    public static final String AUTHORIZATION = "aas.authorization";
    public static final String TOKEN_ENDPOINT = "tokenEndpoint";
    public static final String CLIENT_ID = "clientId";
    public static final String CLIENT_SECRET = "clientSecret";
    public static final String CLIENT_SCOPES = "clientScopes";
    public static final String PROPERTY_DELEGATION = "aas.delegation";
    public static final String DEFAULT_CONFIG_PATH = "aas.properties";
    public static final String DEFAULT_FILE_KEY = "BASYX_AAS";
    public static final String PATTERN = "^\\[\\\".*\\\"\\]$";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(BACKEND, DEFAULT_BACKEND);
        defaultProps.put(SOURCE, "");
        defaultProps.put(REGISTRY, "");
        defaultProps.put(HOSTPATH, "");
        defaultProps.put(SUBMODELS, "[]");
        defaultProps.put(EVENTS, DEFAULT_EVENTS);
        defaultProps.put(AASX_UPLOAD, "Enabled");
        defaultProps.put(AUTHORIZATION, "Disabled");
        defaultProps.put(TOKEN_ENDPOINT, "");
        defaultProps.put(CLIENT_ID, "");
        defaultProps.put(CLIENT_SECRET, "");
        defaultProps.put(CLIENT_SCOPES, "[]");
        defaultProps.put(PROPERTY_DELEGATION, "Enabled");
        return defaultProps;
    }

    public BaSyxAASServerConfiguration() {
        super(BaSyxAASServerConfiguration.getDefaultProperties());
    }

    public BaSyxAASServerConfiguration(AASServerBackend backend, String source) {
        super(BaSyxAASServerConfiguration.getDefaultProperties());
        this.setAASBackend(backend);
        this.setAASSourceAsList(source);
    }

    public BaSyxAASServerConfiguration(AASServerBackend backend, String source, String registryUrl) {
        this(backend, source);
        this.setRegistry(registryUrl);
    }

    public BaSyxAASServerConfiguration(AASServerBackend backend, String source, String registryUrl, String hostPath) {
        this(backend, source, registryUrl);
        this.setHostpath(hostPath);
    }

    public BaSyxAASServerConfiguration(Map<String, String> values) {
        super(values);
    }

    public void loadFromEnvironmentVariables() {
        String[] properties = new String[]{REGISTRY, BACKEND, SOURCE, EVENTS, HOSTPATH, AASX_UPLOAD, AUTHORIZATION, TOKEN_ENDPOINT, CLIENT_ID, CLIENT_SECRET, CLIENT_SCOPES, PROPERTY_DELEGATION, ID};
        this.loadFromEnvironmentVariables(ENV_PREFIX, properties);
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
        this.loadFromEnvironmentVariables();
    }

    public IAuthorizationSupplier configureAndGetAuthorizationSupplier() {
        if (!this.isAuthorizationCredentialsForSecuredRegistryConfigured()) {
            throw new AuthorizationConfigurationException("Authorization credentials for the secured registry is not configured");
        }
        return new OAuth2ClientCredentialsBasedAuthorizationSupplier(this.getTokenEndpoint(), this.getClientId(), this.getClientSecret(), this.getClientScopes());
    }

    public String getAASId() {
        return this.getProperty(ID);
    }

    public AASServerBackend getAASBackend() {
        return AASServerBackend.fromString(this.getProperty(BACKEND));
    }

    public void setAASBackend(AASServerBackend backend) {
        this.setProperty(BACKEND, backend.toString());
    }

    public AASEventBackend getAASEvents() {
        return AASEventBackend.fromString(this.getProperty(EVENTS));
    }

    public void setAASEvents(AASEventBackend events) {
        this.setProperty(EVENTS, events.toString());
    }

    public boolean isAASXUploadEnabled() {
        return this.getProperty(AASX_UPLOAD).equals("Enabled");
    }

    public void enableAASXUpload() {
        this.setProperty(AASX_UPLOAD, "Enabled");
    }

    public void disableAASXUpload() {
        this.setProperty(AASX_UPLOAD, "Disabled");
    }

    @Deprecated
    public String getAASSource() {
        return this.getProperty(SOURCE);
    }

    public List<String> getAASSourceAsList() {
        if (!this.areMultipleAasSourcesProvided(this.getProperty(SOURCE))) {
            return Arrays.asList(this.getProperty(SOURCE));
        }
        return this.parseFromJson(this.getProperty(SOURCE));
    }

    private boolean areMultipleAasSourcesProvided(String property) {
        return Pattern.matches(PATTERN, property);
    }

    @Deprecated
    public void setAASSource(String source) {
        this.setProperty(SOURCE, source);
    }

    public void setAASSourceAsList(String source) {
        this.setProperty(SOURCE, source);
    }

    public String getRegistry() {
        return this.getProperty(REGISTRY);
    }

    public void setRegistry(String registryPath) {
        this.setProperty(REGISTRY, registryPath);
    }

    public List<String> getSubmodels() {
        return this.parseFromJson(this.getProperty(SUBMODELS));
    }

    public void setSubmodels(List<String> submodels) {
        this.setProperty(SUBMODELS, this.serializeSubmodels(submodels));
    }

    public String getHostpath() {
        return this.getProperty(HOSTPATH);
    }

    public void setHostpath(String hostPath) {
        this.setProperty(HOSTPATH, hostPath);
    }

    private List<String> parseFromJson(String property) {
        List fromJson = (List)new Gson().fromJson(property, List.class);
        if (fromJson == null) {
            return new ArrayList<String>();
        }
        return fromJson;
    }

    private <T> T parseFromJson(String property, Class<T> classTypeT) {
        Object fromJson = new Gson().fromJson(property, classTypeT);
        if (fromJson == null) {
            return null;
        }
        return (T)fromJson;
    }

    private String serializeSubmodels(List<String> submodels) {
        return new Gson().toJson(submodels);
    }

    public boolean isAuthorizationEnabled() {
        return this.getProperty(AUTHORIZATION).equals("Enabled");
    }

    public void enableAuthorization() {
        this.setProperty(AUTHORIZATION, "Enabled");
    }

    public void disableAuthorization() {
        this.setProperty(AUTHORIZATION, "Disabled");
    }

    public String getTokenEndpoint() {
        return this.getProperty(TOKEN_ENDPOINT);
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.setProperty(TOKEN_ENDPOINT, tokenEndpoint);
    }

    public String getClientId() {
        return this.getProperty(CLIENT_ID);
    }

    public void setClientId(String clientId) {
        this.setProperty(CLIENT_ID, clientId);
    }

    public String getClientSecret() {
        return this.getProperty(CLIENT_SECRET);
    }

    public void setClientSecret(String clientSecret) {
        this.setProperty(CLIENT_SECRET, clientSecret);
    }

    public Set<String> getClientScopes() {
        return this.parseFromJson(this.getProperty(CLIENT_SCOPES), Set.class);
    }

    public void setClientScopes(String clientScopes) {
        this.setProperty(CLIENT_SCOPES, clientScopes);
    }

    public void enablePropertyDelegation() {
        this.setProperty(PROPERTY_DELEGATION, "Enabled");
    }

    public void disablePropertyDelegation() {
        this.setProperty(PROPERTY_DELEGATION, "Disabled");
    }

    public boolean isPropertyDelegationEnabled() {
        return this.getProperty(PROPERTY_DELEGATION).equals("Enabled");
    }

    public boolean isAuthorizationCredentialsForSecuredRegistryConfigured() {
        return this.isTokenEndpointConfigured() && this.isClientIdConfigured() && this.isClientSecretConfigured() && this.isScopeConfigured();
    }

    private boolean isTokenEndpointConfigured() {
        return this.getProperty(TOKEN_ENDPOINT) != null && !this.getProperty(TOKEN_ENDPOINT).isEmpty();
    }

    private boolean isClientIdConfigured() {
        return this.getProperty(CLIENT_ID) != null && !this.getProperty(CLIENT_ID).isEmpty();
    }

    private boolean isClientSecretConfigured() {
        return this.getProperty(CLIENT_SECRET) != null && !this.getProperty(CLIENT_SECRET).isEmpty();
    }

    private boolean isScopeConfigured() {
        return this.getProperty(CLIENT_SCOPES) != null && !this.getProperty(CLIENT_SCOPES).isEmpty();
    }
}

