/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mqtt;

import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.eclipse.basyx.components.configuration.MqttPersistence;
import org.eclipse.basyx.extensions.submodel.mqtt.MqttSubmodelAPI;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.submodel.restapi.vab.VABSubmodelAPI;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.lambda.VABLambdaProvider;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MqttSubmodelAPIFactory
implements ISubmodelAPIFactory {
    private static Logger logger = LoggerFactory.getLogger(MqttSubmodelAPIFactory.class);
    private BaSyxMqttConfiguration config;

    public MqttSubmodelAPIFactory(BaSyxMqttConfiguration config) {
        this.config = config;
    }

    public ISubmodelAPI getSubmodelAPI(Submodel sm) {
        MqttSubmodelAPI api;
        String smId = sm.getIdentification().getId();
        VABLambdaProvider provider = new VABLambdaProvider((Map)sm);
        VABSubmodelAPI observedApi = new VABSubmodelAPI((IModelProvider)provider);
        String brokerEndpoint = this.config.getServer();
        String clientId = smId;
        try {
            MqttClientPersistence persistence = MqttSubmodelAPIFactory.getMqttPersistenceFromConfig(this.config);
            if (this.config.getUser() != null) {
                String user = this.config.getUser();
                String pass = this.config.getPass();
                api = new MqttSubmodelAPI((ISubmodelAPI)observedApi, brokerEndpoint, clientId, user, pass.toCharArray(), persistence);
            } else {
                api = new MqttSubmodelAPI((ISubmodelAPI)observedApi, brokerEndpoint, clientId, persistence);
            }
            this.setWhitelist(api, smId);
        }
        catch (MqttException e) {
            logger.error("Could not create MqttSubmodelApi", (Throwable)e);
            return observedApi;
        }
        return api;
    }

    private static MqttClientPersistence getMqttPersistenceFromConfig(BaSyxMqttConfiguration config) {
        String persistenceFilePath = config.getPersistencePath();
        MqttPersistence persistenceType = config.getPersistenceType();
        if (MqttSubmodelAPIFactory.isFilePersistenceType(persistenceType)) {
            return MqttSubmodelAPIFactory.createMqttFilePersistence(persistenceFilePath);
        }
        return new MemoryPersistence();
    }

    private static MqttClientPersistence createMqttFilePersistence(String persistenceFilePath) {
        if (!MqttSubmodelAPIFactory.isFilePathSet(persistenceFilePath)) {
            return new MqttDefaultFilePersistence();
        }
        return new MqttDefaultFilePersistence(persistenceFilePath);
    }

    private static boolean isFilePathSet(String persistenceFilePath) {
        return persistenceFilePath != null && !persistenceFilePath.isEmpty();
    }

    private static boolean isFilePersistenceType(MqttPersistence persistenceType) {
        return persistenceType == MqttPersistence.FILE;
    }

    private void setWhitelist(MqttSubmodelAPI api, String smId) {
        if (!this.config.isWhitelistEnabled(smId)) {
            api.disableWhitelist();
            return;
        }
        Set whitelist = this.config.getWhitelist(smId);
        logger.info("Set MQTT whitelist for " + smId + " with " + whitelist.size() + " entries");
        api.setWhitelist(whitelist);
        api.enableWhitelist();
    }
}

