/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration.builder;

import org.eclipse.basyx.aas.manager.ConnectedAssetAdministrationShellManager;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.proxy.AASRegistryProxy;
import org.eclipse.basyx.components.configuration.CFGBaSyxProtocolType;
import org.eclipse.basyx.components.configuration.ConfigurableComponent;
import org.eclipse.basyx.components.configuration.builder.BaSyxConfigurationBuilder;
import org.eclipse.basyx.vab.manager.VABConnectionManager;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;
import org.eclipse.basyx.vab.registry.api.IVABRegistryService;

public class BaSyxServiceConfigurationBuilder<T extends BaSyxServiceConfigurationBuilder<T>>
extends BaSyxConfigurationBuilder<Void> {
    protected String registryURL = null;
    protected CFGBaSyxProtocolType protocoltype = null;
    protected IVABRegistryService vabDirectory = null;

    public BaSyxServiceConfigurationBuilder(ConfigurableComponent<?> component) {
        this.setConfiguredComponent(component);
    }

    public T registryURL(String url) {
        this.registryURL = url;
        return (T)this;
    }

    public IAASRegistry getRegistry() {
        return new AASRegistryProxy(this.registryURL);
    }

    public T connectionManagerType(CFGBaSyxProtocolType protocol) {
        this.protocoltype = protocol;
        return (T)this;
    }

    public T directoryService(IVABRegistryService vabDirectory) {
        this.vabDirectory = vabDirectory;
        return (T)this;
    }

    public VABConnectionManager getConnectionManager() {
        return new VABConnectionManager(this.vabDirectory, (IConnectorFactory)new HTTPConnectorFactory());
    }

    public ConnectedAssetAdministrationShellManager getConnetedAASManager() {
        return new ConnectedAssetAdministrationShellManager(this.getRegistry(), (IConnectorFactory)new HTTPConnectorFactory());
    }
}

