/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.qpid.server.logging.LogMessage;
import org.slf4j.LoggerFactory;

public class TransactionLogMessages {
    private static final ResourceBundle MESSAGES;
    private static final Locale CURRENT_LOCALE;
    public static final String TRANSACTIONLOG_LOG_HIERARCHY = "qpid.message.transactionlog";
    public static final String CLOSED_LOG_HIERARCHY = "qpid.message.transactionlog.closed";
    public static final String CREATED_LOG_HIERARCHY = "qpid.message.transactionlog.created";
    public static final String RECOVERED_LOG_HIERARCHY = "qpid.message.transactionlog.recovered";
    public static final String RECOVERY_COMPLETE_LOG_HIERARCHY = "qpid.message.transactionlog.recovery_complete";
    public static final String RECOVERY_START_LOG_HIERARCHY = "qpid.message.transactionlog.recovery_start";
    public static final String STORE_LOCATION_LOG_HIERARCHY = "qpid.message.transactionlog.store_location";
    public static final String XA_INCOMPLETE_MESSAGE_LOG_HIERARCHY = "qpid.message.transactionlog.xa_incomplete_message";
    public static final String XA_INCOMPLETE_QUEUE_LOG_HIERARCHY = "qpid.message.transactionlog.xa_incomplete_queue";

    public static LogMessage CLOSED() {
        String rawMessage;
        final String message = rawMessage = MESSAGES.getString("CLOSED");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TransactionLogMessages.CLOSED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage CREATED() {
        String rawMessage;
        final String message = rawMessage = MESSAGES.getString("CREATED");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TransactionLogMessages.CREATED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage RECOVERED(Number param1, String param2) {
        String rawMessage = MESSAGES.getString("RECOVERED");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TransactionLogMessages.RECOVERED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage RECOVERY_COMPLETE(String param1, boolean opt1) {
        String rawMessage = MESSAGES.getString("RECOVERY_COMPLETE");
        StringBuffer msg = new StringBuffer();
        String[] parts = rawMessage.split("\\[");
        msg.append(parts[0]);
        if (parts.length > 1) {
            int end = parts[1].indexOf(93);
            if (opt1) {
                msg.append(parts[1].substring(0, end));
            }
            msg.append(parts[1].substring(end + 1));
        }
        rawMessage = msg.toString();
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TransactionLogMessages.RECOVERY_COMPLETE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage RECOVERY_START(String param1, boolean opt1) {
        String rawMessage = MESSAGES.getString("RECOVERY_START");
        StringBuffer msg = new StringBuffer();
        String[] parts = rawMessage.split("\\[");
        msg.append(parts[0]);
        if (parts.length > 1) {
            int end = parts[1].indexOf(93);
            if (opt1) {
                msg.append(parts[1].substring(0, end));
            }
            msg.append(parts[1].substring(end + 1));
        }
        rawMessage = msg.toString();
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TransactionLogMessages.RECOVERY_START_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage STORE_LOCATION(String param1) {
        String rawMessage = MESSAGES.getString("STORE_LOCATION");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TransactionLogMessages.STORE_LOCATION_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage XA_INCOMPLETE_MESSAGE(String param1, String param2) {
        String rawMessage = MESSAGES.getString("XA_INCOMPLETE_MESSAGE");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TransactionLogMessages.XA_INCOMPLETE_MESSAGE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage XA_INCOMPLETE_QUEUE(String param1, String param2) {
        String rawMessage = MESSAGES.getString("XA_INCOMPLETE_QUEUE");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TransactionLogMessages.XA_INCOMPLETE_QUEUE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    private TransactionLogMessages() {
    }

    static {
        Locale locale = Locale.US;
        String localeSetting = System.getProperty("qpid.broker_locale");
        if (localeSetting != null) {
            String[] localeParts = localeSetting.split("_");
            String language = localeParts.length > 0 ? localeParts[0] : "";
            String country = localeParts.length > 1 ? localeParts[1] : "";
            String variant = "";
            if (localeParts.length > 2) {
                variant = localeSetting.substring(language.length() + 1 + country.length() + 1);
            }
            locale = new Locale(language, country, variant);
        }
        CURRENT_LOCALE = locale;
        LoggerFactory.getLogger((String)TRANSACTIONLOG_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CLOSED_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CREATED_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)RECOVERED_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)RECOVERY_COMPLETE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)RECOVERY_START_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)STORE_LOCATION_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)XA_INCOMPLETE_MESSAGE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)XA_INCOMPLETE_QUEUE_LOG_HIERARCHY);
        MESSAGES = ResourceBundle.getBundle("org.apache.qpid.server.logging.messages.TransactionLog_logmessages", CURRENT_LOCALE);
    }
}

