/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.util.Strings;

public class ConfiguredObjectFinder {
    private final ConfiguredObject<?> _root;
    private final Map<Class<? extends ConfiguredObject>, List<Class<? extends ConfiguredObject>>> _hierarchies = new HashMap<Class<? extends ConfiguredObject>, List<Class<? extends ConfiguredObject>>>();
    private final Model _model;
    private final Map<Class<? extends ConfiguredObject>, ConfiguredObjectOperation<ConfiguredObject<?>>> _associatedChildrenOperations = new HashMap();

    public ConfiguredObjectFinder(ConfiguredObject<?> root) {
        this._root = root;
        this._model = root.getModel();
        Class<ConfiguredObject> managedCategory = root.getCategoryClass();
        this.addManagedHierarchies(managedCategory, managedCategory);
        for (ConfiguredObjectOperation<?> operation : this._model.getTypeRegistry().getOperations(managedCategory).values()) {
            if (!operation.isAssociateAsIfChildren() || !ConfiguredObjectTypeRegistry.returnsCollectionOfConfiguredObjects(operation)) continue;
            Class associatedChildCategory = ConfiguredObjectTypeRegistry.getCollectionMemberType((ParameterizedType)operation.getGenericReturnType());
            this._associatedChildrenOperations.put(associatedChildCategory, operation);
            this.addManagedHierarchies(associatedChildCategory, associatedChildCategory);
        }
    }

    private void addManagedHierarchies(Class<? extends ConfiguredObject> category, Class<? extends ConfiguredObject> rootCategory) {
        if (!this._hierarchies.containsKey(category)) {
            this._hierarchies.put(category, this.calculateHierarchy(category, rootCategory));
            for (Class<? extends ConfiguredObject> childClass : this._model.getChildTypes(category)) {
                this.addManagedHierarchies(childClass, rootCategory);
            }
        }
    }

    public Collection<Class<? extends ConfiguredObject>> getManagedCategories() {
        return Collections.unmodifiableCollection(this._hierarchies.keySet());
    }

    private String[] getPathElements(String path) {
        String[] pathElements = path.split("(?<!\\\\)" + Pattern.quote("/"));
        for (int i = 0; i < pathElements.length; ++i) {
            pathElements[i] = pathElements[i].replaceAll("\\\\(.)", "$1");
        }
        return pathElements;
    }

    public ConfiguredObject<?> findObjectFromPath(String path, Class<? extends ConfiguredObject> category) {
        return this.findObjectFromPath(Arrays.asList(this.getPathElements(path)), category);
    }

    public ConfiguredObject<?> findObjectFromPath(List<String> path, Class<? extends ConfiguredObject> category) {
        Collection<ConfiguredObject<?>> candidates = this.findObjectsFromPath(path, this.getHierarchy(category), false);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        throw new IllegalArgumentException("More than one object matching path was found");
    }

    public Class<? extends ConfiguredObject>[] getHierarchy(String categoryName) {
        for (Class<? extends ConfiguredObject> category : this._model.getSupportedCategories()) {
            if (!category.getSimpleName().toLowerCase().equals(categoryName)) continue;
            return this.getHierarchy(category);
        }
        return null;
    }

    public Class<? extends ConfiguredObject>[] getHierarchy(Class<? extends ConfiguredObject> category) {
        List<Class<? extends ConfiguredObject>> hierarchy = this._hierarchies.get(ConfiguredObjectTypeRegistry.getCategory(category));
        return hierarchy == null ? null : hierarchy.toArray(new Class[hierarchy.size()]);
    }

    public Set<Class<? extends ConfiguredObject>> getAssociatedChildCategories() {
        return Collections.unmodifiableSet(this._associatedChildrenOperations.keySet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<ConfiguredObject<?>> findObjectsFromPath(List<String> path, Class<? extends ConfiguredObject>[] hierarchy, boolean allowWildcards) {
        ArrayList<ConfiguredObject<Object>> parents = new ArrayList();
        if (hierarchy.length == 0) {
            return Collections.singletonList(this._root);
        }
        HashMap<Class<? extends ConfiguredObject>, String> filters = new HashMap<Class<? extends ConfiguredObject>, String>();
        ArrayList<Object> children = new ArrayList();
        boolean wildcard = false;
        Class<ConfiguredObject> parentType = this._root.getCategoryClass();
        parents.add(this._root);
        for (int i = 0; i < hierarchy.length; ++i) {
            if (this._model.getChildTypes(parentType).contains(hierarchy[i])) {
                parentType = hierarchy[i];
                for (ConfiguredObject configuredObject : parents) {
                    if (path.size() > i && path.get(i) != null && !path.get(i).equals("*") && path.get(i).trim().length() != 0) {
                        ArrayList childrenOfParent = new ArrayList();
                        for (ConfiguredObject configuredObject2 : configuredObject.getChildren(hierarchy[i])) {
                            if (!configuredObject2.getName().equals(path.get(i))) continue;
                            childrenOfParent.add(configuredObject2);
                        }
                        if (childrenOfParent.isEmpty()) {
                            return null;
                        }
                        children.addAll(childrenOfParent);
                        continue;
                    }
                    if (!allowWildcards) return null;
                    wildcard = true;
                    children.addAll(configuredObject.getChildren(hierarchy[i]));
                }
            } else if (i == 0) {
                ConfiguredObjectOperation<ConfiguredObject<?>> op = this._associatedChildrenOperations.get(hierarchy[0]);
                if (op != null) {
                    parentType = hierarchy[i];
                    Collection collection = (Collection)op.perform(this._root, Collections.emptyMap());
                    if (path.size() > i && path.get(i) != null && !path.get(i).equals("*") && path.get(i).trim().length() != 0) {
                        for (ConfiguredObject child : collection) {
                            if (!child.getName().equals(path.get(i))) continue;
                            children.add(child);
                        }
                        if (children.isEmpty()) {
                            return null;
                        }
                    } else {
                        if (!allowWildcards) return null;
                        wildcard = true;
                        children.addAll(collection);
                    }
                }
            } else {
                children = parents;
                if (path.size() > i && path.get(i) != null && !path.get(i).equals("*") && path.get(i).trim().length() != 0) {
                    filters.put(hierarchy[i], path.get(i));
                } else {
                    if (!allowWildcards) return null;
                    wildcard = true;
                }
            }
            parents = children;
            children = new ArrayList();
        }
        if (!filters.isEmpty() && !parents.isEmpty()) {
            ArrayList potentials = parents;
            parents = new ArrayList();
            for (ConfiguredObject configuredObject : potentials) {
                boolean match = true;
                for (Map.Entry entry : filters.entrySet()) {
                    ConfiguredObject ancestor = (ConfiguredObject)configuredObject.getModel().getAncestor((Class)entry.getKey(), configuredObject);
                    match = ancestor != null && ancestor.getName().equals(entry.getValue());
                    if (match) continue;
                    break;
                }
                if (!match) continue;
                parents.add(configuredObject);
            }
        }
        if (!parents.isEmpty()) return parents;
        if (wildcard) return parents;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ConfiguredObject findObjectParentsFromPath(List<String> names, Class<? extends ConfiguredObject>[] hierarchy, Class<? extends ConfiguredObject> objClass) {
        Model model = this._root.getModel();
        Collection[] objects = new Collection[hierarchy.length];
        block0: for (int i = 0; i < hierarchy.length - 1; ++i) {
            void var8_13;
            objects[i] = new HashSet();
            if (i == 0) {
                for (ConfiguredObject configuredObject : this._root.getChildren(hierarchy[0])) {
                    if (!configuredObject.getName().equals(names.get(0))) continue;
                    objects[0].add(configuredObject);
                    continue block0;
                }
                continue;
            }
            boolean foundAncestor = false;
            int n = i - 1;
            while (var8_13 >= 0) {
                if (model.getChildTypes(hierarchy[var8_13]).contains(hierarchy[i])) {
                    for (ConfiguredObject parent : objects[var8_13]) {
                        for (ConfiguredObject configuredObject : parent.getChildren(hierarchy[i])) {
                            if (!configuredObject.getName().equals(names.get(i))) continue;
                            objects[i].add(configuredObject);
                        }
                    }
                    foundAncestor = true;
                    break;
                }
                --var8_13;
            }
            if (foundAncestor || !model.getChildTypes(this._root.getCategoryClass()).contains(hierarchy[i])) continue;
            for (ConfiguredObject configuredObject : this._root.getChildren(hierarchy[i])) {
                if (!configuredObject.getName().equals(names.get(i))) continue;
                objects[i].add(configuredObject);
            }
        }
        Class<? extends ConfiguredObject> parentClass = model.getParentType(objClass);
        for (int i = hierarchy.length - 2; i >= 0; --i) {
            if (!parentClass.equals(hierarchy[i])) continue;
            if (objects[i].size() == 1) {
                return (ConfiguredObject)objects[i].iterator().next();
            }
            throw new IllegalArgumentException("Cannot deduce parent of class " + hierarchy[i].getSimpleName());
        }
        return null;
    }

    public String getPath(ConfiguredObject<?> object) {
        List<String> pathAsList = this.getPathAsList(object);
        ListIterator<String> iter = pathAsList.listIterator();
        while (iter.hasNext()) {
            String element = iter.next();
            iter.set(element.replaceAll("([\\\\/])", "\\\\$1"));
        }
        return Strings.join("/", pathAsList);
    }

    public List<String> getPathAsList(ConfiguredObject<?> object) {
        List<Class<? extends ConfiguredObject>> hierarchy = this._hierarchies.get(object.getCategoryClass());
        ArrayList<String> pathElements = new ArrayList<String>();
        for (Class<? extends ConfiguredObject> ancestorClass : hierarchy) {
            pathElements.add(this._model.getAncestor(ancestorClass, object).getName());
        }
        return pathElements;
    }

    private List<Class<? extends ConfiguredObject>> calculateHierarchy(Class<? extends ConfiguredObject> category, Class<? extends ConfiguredObject> rootClass) {
        Class<ConfiguredObject> managedCategoryClass = this._root.getCategoryClass();
        return ConfiguredObjectFinder.calculateHierarchy(category, rootClass, managedCategoryClass, this._model);
    }

    private static List<Class<? extends ConfiguredObject>> calculateHierarchy(Class<? extends ConfiguredObject> category, Class<? extends ConfiguredObject> rootClass, Class<? extends ConfiguredObject> managedCategoryClass, Model model) {
        ArrayList<Class<? extends ConfiguredObject>> hierarchyList = new ArrayList<Class<? extends ConfiguredObject>>();
        if (category != rootClass) {
            Class<? extends ConfiguredObject> parentCategory;
            hierarchyList.add(category);
            while (!rootClass.equals(parentCategory = model.getParentType(category)) && parentCategory != null) {
                hierarchyList.add(parentCategory);
                if (!model.getAncestorCategories(parentCategory).contains(rootClass)) break;
                category = parentCategory;
            }
        }
        if (rootClass != managedCategoryClass) {
            hierarchyList.add(rootClass);
        }
        Collections.reverse(hierarchyList);
        return hierarchyList;
    }

    public Collection<? extends ConfiguredObject> getAssociatedChildren(Class<? extends ConfiguredObject> childClass) {
        ConfiguredObjectOperation<ConfiguredObject<?>> op = this._associatedChildrenOperations.get(childClass);
        if (op != null) {
            return Collections.unmodifiableCollection((Collection)op.perform(this._root, Collections.emptyMap()));
        }
        return Collections.emptySet();
    }
}

