/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AbstractKeyStore;
import org.apache.qpid.server.security.AutoGeneratedSelfSignedKeyStore;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.Strings;

public class AutoGeneratedSelfSignedKeyStoreImpl
extends AbstractKeyStore<AutoGeneratedSelfSignedKeyStoreImpl>
implements AutoGeneratedSelfSignedKeyStore<AutoGeneratedSelfSignedKeyStoreImpl> {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final Broker<?> _broker;
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private volatile String _keyAlgorithm;
    @ManagedAttributeField
    private volatile String _signatureAlgorithm;
    @ManagedAttributeField
    private volatile int _keyLength;
    @ManagedAttributeField
    private volatile int _durationInMonths;
    private volatile PrivateKey _privateKey;
    private volatile X509Certificate _certificate;
    private volatile KeyManager[] _keyManagers;
    private volatile boolean _generated;
    private volatile boolean _created;

    @ManagedObjectFactoryConstructor(conditionallyAvailable=true)
    public AutoGeneratedSelfSignedKeyStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
        this._broker = broker;
        this._eventLogger = this._broker.getEventLogger();
    }

    @Override
    public KeyManager[] getKeyManagers() throws GeneralSecurityException {
        KeyManager[] keyManagers = this._keyManagers;
        return keyManagers == null ? new KeyManager[]{} : Arrays.copyOf(keyManagers, keyManagers.length);
    }

    @Override
    public String getKeyAlgorithm() {
        return this._keyAlgorithm;
    }

    @Override
    public String getSignatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    @Override
    public int getKeyLength() {
        return this._keyLength;
    }

    @Override
    public int getDurationInMonths() {
        return this._durationInMonths;
    }

    @Override
    public String getEncodedCertificate() {
        try {
            return Base64.getEncoder().encodeToString(this._certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new IllegalConfigurationException("Cannot encode certificate", e);
        }
    }

    @Override
    public String getEncodedPrivateKey() {
        return Base64.getEncoder().encodeToString(this._privateKey.getEncoded());
    }

    @Override
    protected void postResolve() {
        super.postResolve();
        if (this.getActualAttributes().containsKey("encodedPrivateKey") && this.getActualAttributes().containsKey("encodedCertificate")) {
            this.loadPrivateKeyAndCertificate();
        } else {
            this.generatePrivateKeyAndCertificate();
        }
        this.generateKeyManagers();
    }

    private void loadPrivateKeyAndCertificate() {
        byte[] privateKeyEncoded = Strings.decodeBase64((String)this.getActualAttributes().get("encodedPrivateKey"));
        byte[] certificateEncoded = Strings.decodeBase64((String)this.getActualAttributes().get("encodedCertificate"));
        try (ByteArrayInputStream input = new ByteArrayInputStream(certificateEncoded);){
            this._certificate = (X509Certificate)SSLUtil.getCertificateFactory().generateCertificate(input);
        }
        catch (IOException | CertificateException e) {
            throw new IllegalConfigurationException("Could not decode certificate", e);
        }
        try {
            this._privateKey = SSLUtil.readPrivateKey(privateKeyEncoded, this._keyAlgorithm);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalConfigurationException("Could not decode private key", e);
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this._created = true;
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.initializeExpiryChecking();
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.STOPPED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> activate() {
        if (!this._created) {
            this.saveDerivedAttributesIfNecessary();
        }
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    private void saveDerivedAttributesIfNecessary() {
        if (this._generated) {
            String encodedCertificate = this.getEncodedCertificate();
            this.attributeSet("encodedCertificate", encodedCertificate, encodedCertificate);
            String encodedPrivateKey = this.getEncodedPrivateKey();
            this.attributeSet("encodedPrivateKey", encodedPrivateKey, encodedPrivateKey);
            this._generated = false;
        }
    }

    private void generatePrivateKeyAndCertificate() {
        try {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InterfaceAddress inetAddress : networkInterface.getInterfaceAddresses()) {
                    addresses.add(inetAddress.getAddress());
                }
            }
            HashSet<String> dnsNames = new HashSet<String>();
            for (InetAddress address : addresses) {
                String canonicalHostName;
                String hostName = address.getHostName();
                if (hostName != null) {
                    dnsNames.add(hostName);
                }
                if ((canonicalHostName = address.getCanonicalHostName()) == null) continue;
                dnsNames.add(canonicalHostName);
            }
            long l = System.currentTimeMillis();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l);
            calendar.add(2, this._durationInMonths);
            long duration = (calendar.getTimeInMillis() - l) / 1000L;
            SSLUtil.KeyCertPair keyCertPair = SSLUtil.generateSelfSignedCertificate(this._keyAlgorithm, this._signatureAlgorithm, this._keyLength, l, duration, "CN=Qpid", dnsNames, addresses);
            this._privateKey = keyCertPair.getPrivateKey();
            this._certificate = keyCertPair.getCertificate();
            this._generated = true;
        }
        catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalConfigurationException("Unable to construct keystore", e);
        }
    }

    @Override
    protected void checkCertificateExpiry() {
        int expiryWarning = this.getCertificateExpiryWarnPeriod();
        if (expiryWarning > 0) {
            long currentTime = System.currentTimeMillis();
            Date expiryTestDate = new Date(currentTime + 86400000L * (long)expiryWarning);
            this.checkCertificatesExpiry(currentTime, expiryTestDate, new X509Certificate[]{this._certificate});
        }
    }

    @Override
    protected Collection<Certificate> getCertificates() {
        return Collections.singleton(this._certificate);
    }

    private void generateKeyManagers() {
        try {
            Certificate[] certs = new X509Certificate[]{this._certificate};
            KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            byte[] bytes = new byte[64];
            char[] chars = "".toCharArray();
            RANDOM.nextBytes(bytes);
            StandardCharsets.US_ASCII.decode(ByteBuffer.wrap(bytes)).get(chars);
            inMemoryKeyStore.load(null, chars);
            inMemoryKeyStore.setKeyEntry("1", this._privateKey, chars, certs);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(inMemoryKeyStore, chars);
            this._keyManagers = kmf.getKeyManagers();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException("Cannot load private key or certificate(s): " + e, e);
        }
    }

    static boolean isAvailable() {
        return SSLUtil.canGenerateCerts();
    }

    @Override
    public void regenerateCertificate() {
        this.generatePrivateKeyAndCertificate();
        this.saveDerivedAttributesIfNecessary();
    }

    @Override
    public Content getClientTrustStore(String password) {
        try {
            KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inMemoryKeyStore.load(null, null);
            inMemoryKeyStore.setCertificateEntry(this.getName(), this._certificate);
            return new TrustStoreContent(inMemoryKeyStore, this.getName(), password == null ? new char[]{} : password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Content getCertificate() {
        try {
            return new CertificateContent(this._certificate, this.getName());
        }
        catch (CertificateEncodingException e) {
            throw new IllegalArgumentException("Cannot decode encode the certificate");
        }
    }

    private static class CertificateContent
    implements Content,
    CustomRestHeaders {
        private final String _disposition;
        private final String _certString;

        public CertificateContent(X509Certificate certificate, String name) throws CertificateEncodingException {
            this._disposition = "attachment; filename=\"" + name + ".pem\"";
            StringBuilder certStringBuffer = new StringBuilder("-----BEGIN CERTIFICATE-----\n");
            String cert = Base64.getEncoder().encodeToString(certificate.getEncoded());
            int offset = 0;
            while (cert.length() - offset > 64) {
                certStringBuffer.append(cert.substring(offset, offset + 64));
                offset += 64;
                certStringBuffer.append("\n");
            }
            certStringBuffer.append(cert.substring(offset));
            certStringBuffer.append("\n-----END CERTIFICATE-----\n");
            this._certString = certStringBuffer.toString();
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            OutputStreamWriter w = new OutputStreamWriter(outputStream);
            w.write(this._certString);
            ((Writer)w).flush();
        }

        @Override
        public void release() {
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "text/plain";
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            return this._disposition;
        }
    }

    private static class TrustStoreContent
    implements Content,
    CustomRestHeaders {
        private final KeyStore _keyStore;
        private final char[] _password;
        private final String _disposition;

        public TrustStoreContent(KeyStore inMemoryKeyStore, String name, char[] password) {
            this._keyStore = inMemoryKeyStore;
            this._password = password;
            this._disposition = "attachment; filename=\"" + name + ".jks\"";
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            try {
                this._keyStore.store(outputStream, this._password);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public void release() {
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "application/octet-stream";
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            return this._disposition;
        }
    }
}

