/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.AbstractCaseAwareGroupProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupManagingGroupProvider;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.CaseAwareGroupProvider;
import org.apache.qpid.server.security.group.GroupPrincipal;

@ManagedObject(category=false, type="ManagedGroupProvider")
public class GroupProviderImpl
extends AbstractCaseAwareGroupProvider<GroupProviderImpl>
implements CaseAwareGroupProvider<GroupProviderImpl>,
GroupManagingGroupProvider {
    public static final String CONFIG_TYPE = "ManagedGroupProvider";

    @ManagedObjectFactoryConstructor
    public GroupProviderImpl(Map<String, Object> attributes, Container<?> container) {
        super(container, attributes);
    }

    @Override
    public Set<Principal> getGroupPrincipalsForUser(Principal userPrincipal) {
        HashSet<Principal> principals = new HashSet<Principal>();
        Collection<Group> groups = this.getChildren(Group.class);
        for (Group group : groups) {
            for (GroupMember member : group.getChildren(GroupMember.class)) {
                if (!member.getName().equals(userPrincipal.getName())) continue;
                principals.add(new GroupPrincipal(group.getName(), this));
            }
        }
        return principals;
    }

    @Override
    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes) {
        if (childClass == Group.class) {
            return this.getObjectFactory().createAsync(childClass, attributes, this);
        }
        return super.addChildAsync(childClass, attributes);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }
}

