/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.store.ConfiguredObjectDependency;
import org.apache.qpid.server.store.ConfiguredObjectIdDependency;
import org.apache.qpid.server.store.ConfiguredObjectNameDependency;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;
import org.apache.qpid.server.store.UnresolvedConfiguredObject;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRecoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericRecoverer.class);
    private final ConfiguredObject<?> _root;

    public GenericRecoverer(ConfiguredObject<?> root) {
        this._root = root;
    }

    public void recover(final List<ConfiguredObjectRecord> records, final boolean isNew) {
        this._root.getTaskExecutor().run(new Task<Void, RuntimeException>(){

            @Override
            public Void execute() {
                GenericRecoverer.this.performRecover(records, isNew);
                return null;
            }

            @Override
            public String getObject() {
                return GenericRecoverer.this._root.toString();
            }

            @Override
            public String getAction() {
                return "recover";
            }

            @Override
            public String getArguments() {
                return null;
            }
        });
    }

    private void performRecover(List<ConfiguredObjectRecord> records, boolean isNew) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Recovering the children of " + this._root);
        }
        records = this.resolveDiscontinuity(records);
        this.resolveObjects(this._root, records, isNew);
    }

    private List<ConfiguredObjectRecord> resolveDiscontinuity(List<ConfiguredObjectRecord> records) {
        Collection<Class<? extends ConfiguredObject>> childTypesOfRoot = this._root.getModel().getChildTypes(this._root.getCategoryClass());
        ArrayList<ConfiguredObjectRecord> newRecords = new ArrayList<ConfiguredObjectRecord>(records.size());
        for (ConfiguredObjectRecord record : records) {
            if (record.getId().equals(this._root.getId())) continue;
            if (record.getParents() == null || record.getParents().size() == 0) {
                if (this.containsCategory(childTypesOfRoot, record.getType())) {
                    String parentOfRootCategory = this._root.getCategoryClass().getSimpleName();
                    Map<String, UUID> rootParents = Collections.singletonMap(parentOfRootCategory, this._root.getId());
                    newRecords.add(new ConfiguredObjectRecordImpl(record.getId(), record.getType(), record.getAttributes(), rootParents));
                    continue;
                }
                throw new IllegalArgumentException("Recovered configured object record " + record + " has no recorded parents and is not a valid child type [" + Arrays.toString(childTypesOfRoot.toArray()) + "] for the root " + this._root);
            }
            newRecords.add(record);
        }
        return newRecords;
    }

    private boolean containsCategory(Collection<Class<? extends ConfiguredObject>> childCategories, String categorySimpleName) {
        for (Class<? extends ConfiguredObject> child : childCategories) {
            if (!child.getSimpleName().equals(categorySimpleName)) continue;
            return true;
        }
        return false;
    }

    private void resolveObjects(ConfiguredObject<?> parentObject, List<ConfiguredObjectRecord> records, boolean isNew) {
        boolean updatesMade;
        ConfiguredObjectFactory factory = parentObject.getObjectFactory();
        HashMap<UUID, ConfiguredObject<Object>> resolvedObjects = new HashMap<UUID, ConfiguredObject<Object>>();
        resolvedObjects.put(parentObject.getId(), parentObject);
        ArrayList<ConfiguredObjectRecord> recordsWithUnresolvedParents = new ArrayList<ConfiguredObjectRecord>(records);
        ArrayList recordsWithUnresolvedDependencies = new ArrayList();
        do {
            updatesMade = false;
            Iterator iter = recordsWithUnresolvedParents.iterator();
            while (iter.hasNext()) {
                ConfiguredObjectRecord record = (ConfiguredObjectRecord)iter.next();
                ArrayList<ConfiguredObject> parents = new ArrayList<ConfiguredObject>();
                boolean foundParents = true;
                for (UUID uUID : record.getParents().values()) {
                    if (!resolvedObjects.containsKey(uUID)) {
                        foundParents = false;
                        break;
                    }
                    parents.add((ConfiguredObject)resolvedObjects.get(uUID));
                }
                if (parents.size() > 1) {
                    throw new IllegalStateException(String.format("Unexpected number of parents %d for record %s ", parents.size(), record));
                }
                if (!foundParents) continue;
                iter.remove();
                ConfiguredObject[] parentArray = parents.toArray(new ConfiguredObject[parents.size()]);
                UnresolvedConfiguredObject unresolvedConfiguredObject = factory.recover(record, parentArray[0]);
                Collection<ConfiguredObjectDependency<?>> dependencies = unresolvedConfiguredObject.getUnresolvedDependencies();
                if (dependencies.isEmpty()) {
                    updatesMade = true;
                    Object resolved = unresolvedConfiguredObject.resolve();
                    if (!isNew) {
                        resolved.decryptSecrets();
                    }
                    resolvedObjects.put(resolved.getId(), (ConfiguredObject<Object>)resolved);
                    continue;
                }
                recordsWithUnresolvedDependencies.add(unresolvedConfiguredObject);
            }
            Iterator unresolvedIter = recordsWithUnresolvedDependencies.iterator();
            while (unresolvedIter.hasNext()) {
                UnresolvedConfiguredObject unresolvedObject = (UnresolvedConfiguredObject)unresolvedIter.next();
                ArrayList dependencies = new ArrayList(unresolvedObject.getUnresolvedDependencies());
                for (ConfiguredObjectDependency configuredObjectDependency : dependencies) {
                    if (configuredObjectDependency instanceof ConfiguredObjectIdDependency) {
                        UUID id = ((ConfiguredObjectIdDependency)configuredObjectDependency).getId();
                        if (!resolvedObjects.containsKey(id)) continue;
                        configuredObjectDependency.resolve((ConfiguredObject)resolvedObjects.get(id));
                        continue;
                    }
                    if (configuredObjectDependency instanceof ConfiguredObjectNameDependency) {
                        Object dependentObject = null;
                        ConfiguredObject<?> parent = unresolvedObject.getParent();
                        dependentObject = parent.findConfiguredObject(configuredObjectDependency.getCategoryClass(), ((ConfiguredObjectNameDependency)configuredObjectDependency).getName());
                        if (dependentObject == null) continue;
                        configuredObjectDependency.resolve(dependentObject);
                        continue;
                    }
                    throw new ServerScopedRuntimeException("Unknown dependency type " + configuredObjectDependency.getClass().getSimpleName());
                }
                if (!unresolvedObject.getUnresolvedDependencies().isEmpty()) continue;
                updatesMade = true;
                unresolvedIter.remove();
                Object resolved = unresolvedObject.resolve();
                resolvedObjects.put(resolved.getId(), (ConfiguredObject<Object>)resolved);
            }
        } while (updatesMade && (!recordsWithUnresolvedDependencies.isEmpty() || !recordsWithUnresolvedParents.isEmpty()));
        if (!recordsWithUnresolvedDependencies.isEmpty()) {
            throw new IllegalArgumentException("Cannot resolve some objects: " + recordsWithUnresolvedDependencies);
        }
        if (!recordsWithUnresolvedParents.isEmpty()) {
            throw new IllegalArgumentException("Cannot resolve object because their parents cannot be found" + recordsWithUnresolvedParents);
        }
    }
}

