/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.metamodel.map.parts;

import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.IEmbeddedDataSpecification;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IAdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.AdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Identifiable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.vab.model.VABModelMap;

public class Asset
extends VABModelMap<Object>
implements IAsset {
    public static String ASSETIDENTIFICATIONMODEL = "assetIdentificationModel";
    public static String MODELTYPE = "Asset";
    public static final String KIND = "kind";
    public static final String BILLOFMATERIAL = "billOfMaterial";

    public Asset() {
        this.putAll(new ModelType(MODELTYPE));
        this.putAll(new HasDataSpecification());
        this.putAll(new Identifiable());
        this.setAssetKind(AssetKind.INSTANCE);
    }

    public Asset(String idShort, IIdentifier identification, AssetKind kind) {
        this();
        this.setIdentification(identification);
        this.setIdShort(idShort);
        this.setAssetKind(kind);
    }

    public Asset(Reference submodel) {
        this();
        this.put(ASSETIDENTIFICATIONMODEL, submodel);
    }

    public static Asset createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (!Asset.isValid(map)) {
            throw new MetamodelConstructionException(Asset.class, map);
        }
        Asset ret = new Asset();
        ret.setMap(map);
        return ret;
    }

    public static boolean isValid(Map<String, Object> map) {
        return Identifiable.isValid(map) && map.containsKey(KIND);
    }

    @Override
    public Collection<IReference> getDataSpecificationReferences() {
        return HasDataSpecification.createAsFacade(this).getDataSpecificationReferences();
    }

    public void setDataSpecificationReferences(Collection<IReference> ref) {
        HasDataSpecification.createAsFacade(this).setDataSpecificationReferences(ref);
    }

    @Override
    public Collection<IEmbeddedDataSpecification> getEmbeddedDataSpecifications() {
        return HasDataSpecification.createAsFacade(this).getEmbeddedDataSpecifications();
    }

    public void setEmbeddedDataSpecifications(Collection<IEmbeddedDataSpecification> embeddedDataSpecifications) {
        HasDataSpecification.createAsFacade(this).setEmbeddedDataSpecifications(embeddedDataSpecifications);
    }

    @Override
    public AssetKind getAssetKind() {
        return AssetKind.fromString((String)this.get(KIND));
    }

    public void setAssetKind(AssetKind kind) {
        this.put(KIND, kind.toString());
    }

    @Override
    public IAdministrativeInformation getAdministration() {
        return Identifiable.createAsFacade(this, this.getKeyElement()).getAdministration();
    }

    @Override
    public IIdentifier getIdentification() {
        return Identifiable.createAsFacade(this, this.getKeyElement()).getIdentification();
    }

    public void setAdministration(AdministrativeInformation information) {
        Identifiable.createAsFacade(this, this.getKeyElement()).setAdministration(information);
    }

    public void setIdentification(IIdentifier id) {
        this.setIdentification(id.getIdType(), id.getId());
    }

    public void setIdentification(IdentifierType idType, String id) {
        Identifiable.createAsFacadeNonStrict(this, this.getKeyElement()).setIdentification(idType, id);
    }

    @Override
    public IReference getAssetIdentificationModel() {
        return Reference.createAsFacade((Map)this.get(ASSETIDENTIFICATIONMODEL));
    }

    public void setAssetIdentificationModel(IReference submodel) {
        this.put(ASSETIDENTIFICATIONMODEL, submodel);
    }

    @Override
    public String getIdShort() {
        return Referable.createAsFacade(this, this.getKeyElement()).getIdShort();
    }

    @Override
    public String getCategory() {
        return Referable.createAsFacade(this, this.getKeyElement()).getCategory();
    }

    @Override
    public LangStrings getDescription() {
        return Referable.createAsFacade(this, this.getKeyElement()).getDescription();
    }

    @Override
    public IReference getParent() {
        return Referable.createAsFacade(this, this.getKeyElement()).getParent();
    }

    public void setIdShort(String idShort) {
        Referable.createAsFacadeNonStrict(this, this.getKeyElement()).setIdShort(idShort);
    }

    public void setCategory(String category) {
        Referable.createAsFacade(this, this.getKeyElement()).setCategory(category);
    }

    public void setDescription(LangStrings description) {
        Referable.createAsFacade(this, this.getKeyElement()).setDescription(description);
    }

    public void setParent(IReference obj) {
        Referable.createAsFacade(this, this.getKeyElement()).setParent(obj);
    }

    @Override
    public IReference getBillOfMaterial() {
        return Reference.createAsFacade((Map)this.get(BILLOFMATERIAL));
    }

    public void setBillOfMaterial(Reference reference) {
        this.put(BILLOFMATERIAL, reference);
    }

    private KeyElements getKeyElement() {
        return KeyElements.ASSET;
    }

    @Override
    public IReference getReference() {
        return Identifiable.createAsFacade(this, this.getKeyElement()).getReference();
    }
}

