/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.registration.restapi;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.memory.InMemoryRegistry;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class AASRegistryModelProvider
implements IModelProvider {
    IAASRegistry registry;
    public static final String PREFIX = "api/v1/registry";
    public static final String SUBMODELS = "submodels";

    public AASRegistryModelProvider(IAASRegistry registry) {
        this.registry = registry;
    }

    public AASRegistryModelProvider() {
        this(new InMemoryRegistry());
    }

    private String stripPrefix(String path) throws MalformedRequestException {
        if (!(path = VABPathTools.stripSlashes(path)).startsWith(PREFIX)) {
            throw new MalformedRequestException("Path " + path + " not recognized as registry path. Has to start with api/v1/registry");
        }
        path = path.replaceFirst(PREFIX, "");
        path = VABPathTools.stripSlashes(path);
        return path;
    }

    private String[] splitPath(String path) throws MalformedRequestException {
        if (path.isEmpty()) {
            return new String[0];
        }
        String[] splitted = path.split("/");
        if (splitted[0].equals(SUBMODELS)) {
            throw new MalformedRequestException("Path must not start with submodels");
        }
        if (splitted.length > 1 && !splitted[1].equals(SUBMODELS)) {
            throw new MalformedRequestException("Second path element must be (if present): submodels");
        }
        return splitted;
    }

    private String[] preparePath(String path) throws MalformedRequestException {
        path = this.stripPrefix(path);
        String[] splitted = this.splitPath(path);
        try {
            for (int i = 0; i < splitted.length; ++i) {
                splitted[i] = URLDecoder.decode(splitted[i], "UTF-8");
            }
            return splitted;
        }
        catch (UnsupportedEncodingException e) {
            throw new MalformedRequestException("Path has to be encoded as UTF-8 string.");
        }
    }

    private Map<String, Object> checkModelType(String expectedModelType, Object value) throws MalformedRequestException {
        if (!(value instanceof Map)) {
            throw new MalformedRequestException("Given newValue is not a Map");
        }
        Map map = (Map)value;
        String type = ModelType.createAsFacade(map).getName();
        if (!expectedModelType.equals(type) && type != null) {
            throw new MalformedRequestException("Given newValue map has not the correct ModelType");
        }
        return map;
    }

    private AASDescriptor createAASDescriptorFromMap(Object value) throws MalformedRequestException {
        Map<String, Object> map = this.checkModelType("AssetAdministrationShellDescriptor", value);
        AASDescriptor aasDescriptor = new AASDescriptor(map);
        return aasDescriptor;
    }

    private SubmodelDescriptor createSMDescriptorFromMap(Object value) throws MalformedRequestException {
        Map<String, Object> map = this.checkModelType("SubmodelDescriptor", value);
        SubmodelDescriptor smDescriptor = new SubmodelDescriptor(map);
        return smDescriptor;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        String[] splitted = this.preparePath(path);
        if (this.isRequestForAllAASDescriptors(splitted)) {
            return this.registry.lookupAll();
        }
        if (this.isRequestForAASDescriptor(splitted)) {
            return this.getAASDescriptor(splitted);
        }
        if (this.isRequestForSubmodelDescriptorsOfAAS(splitted)) {
            return this.getSmDescriptorsFromAAS(this.createAASModelUrn(splitted));
        }
        if (this.isRequestForSubmodelDescriptorOfAAS(splitted)) {
            return this.getSubmodelDescriptor(splitted);
        }
        throw new MalformedRequestException(this.createInvalidPathMessage(path));
    }

    private String createInvalidPathMessage(String path) {
        return "Given path '" + path + "' contains more than three path elements and is therefore invalid.";
    }

    private Object getSubmodelDescriptor(String[] splitted) {
        SubmodelDescriptor smDescriptor = this.getSmDescriptorFromAAS(this.createAASModelUrn(splitted), splitted[2]);
        if (smDescriptor == null) {
            throw new ResourceNotFoundException("Specified SubmodelId '" + splitted[2] + "' does not exist in AAS '" + splitted[0] + "'.");
        }
        return smDescriptor;
    }

    private boolean isRequestForSubmodelDescriptorOfAAS(String[] splitted) {
        return splitted.length == 3;
    }

    private boolean isRequestForSubmodelDescriptorsOfAAS(String[] splitted) {
        return splitted.length == 2;
    }

    private boolean isRequestForAASDescriptor(String[] splitted) {
        return splitted.length == 1;
    }

    private boolean isRequestForAllAASDescriptors(String[] splitted) {
        return splitted.length == 0;
    }

    private Object getAASDescriptor(String[] splitted) {
        AASDescriptor descriptor = this.registry.lookupAAS(this.createAASModelUrn(splitted));
        if (descriptor == null) {
            throw new ResourceNotFoundException("Specified AASid '" + splitted[0] + "' does not exist.");
        }
        return descriptor;
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        String[] splitted = this.preparePath(path);
        if (!this.isValidSetPath(splitted)) {
            throw new MalformedRequestException("Set with empty path is not supported by registry");
        }
        ModelUrn identifier = this.createAASModelUrn(splitted);
        if (this.isRequestForAASDescriptor(splitted)) {
            this.registerAASDescriptor(newValue, splitted);
        } else if (this.isRequestForSubmodelDescriptorOfAAS(splitted)) {
            this.registerSubmodelDescriptor(newValue, identifier);
        } else {
            throw new MalformedRequestException("Unknown path " + path);
        }
    }

    private void registerSubmodelDescriptor(Object newValue, ModelUrn identifier) {
        SubmodelDescriptor smDesc = this.createSMDescriptorFromMap(newValue);
        this.registry.register(identifier, smDesc);
    }

    private void registerAASDescriptor(Object newValue, String[] splitted) {
        String urlId;
        AASDescriptor desc = this.createAASDescriptorFromMap(newValue);
        String descId = desc.getIdentifier().getId();
        if (!descId.equals(urlId = splitted[0])) {
            throw new MalformedRequestException("The Identifier " + descId + " in the descriptor does not match the URL with id " + urlId);
        }
        this.registry.register(desc);
    }

    private boolean isValidSetPath(String[] splitted) {
        return splitted.length > 0;
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        throw new MalformedRequestException("Create (POST) on a registry is not supported. Please, use put");
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        String[] splitted = this.preparePath(path);
        if (!this.isValidDeletePath(splitted)) {
            throw new MalformedRequestException("Delete with empty path is not supported by registry");
        }
        if (this.isRequestForAASDescriptor(splitted)) {
            this.deleteAASDescriptor(splitted);
        } else if (this.isRequestForSubmodelDescriptorOfAAS(splitted)) {
            this.deleteSubmodelDescriptor(splitted);
        }
    }

    private boolean isValidDeletePath(String[] splitted) {
        return splitted.length > 0;
    }

    private void deleteSubmodelDescriptor(String[] splitted) {
        String smId;
        ModelUrn aasId = this.createAASModelUrn(splitted);
        SubmodelDescriptor smDesc = this.getSmDescriptorFromAAS(aasId, smId = splitted[2]);
        if (smDesc == null) {
            throw new ResourceNotFoundException("A Submodel with id '" + smId + "' does not exist in aas '" + aasId + "'.");
        }
        this.registry.delete(aasId, smDesc.getIdentifier());
    }

    private ModelUrn createAASModelUrn(String[] splitted) {
        return new ModelUrn(splitted[0]);
    }

    private void deleteAASDescriptor(String[] splitted) {
        ModelUrn aasId = this.createAASModelUrn(splitted);
        if (this.registry.lookupAAS(aasId) == null) {
            throw new ResourceNotFoundException("AAS '" + aasId + "' to be deleted does not exist.");
        }
        this.registry.delete(aasId);
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("DeleteValue with parameter not supported by registry");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        throw new MalformedRequestException("Invoke not supported by registry");
    }

    private Collection<SubmodelDescriptor> getSmDescriptorsFromAAS(IIdentifier id) throws ResourceNotFoundException {
        AASDescriptor aasDescriptor = this.registry.lookupAAS(id);
        if (aasDescriptor == null) {
            throw new ResourceNotFoundException("Specified AASid '" + id.getId() + "' does not exist.");
        }
        return aasDescriptor.getSubmodelDescriptors();
    }

    private SubmodelDescriptor getSmDescriptorFromAAS(IIdentifier aasId, String smId) throws ResourceNotFoundException {
        AASDescriptor aasDescriptor = this.registry.lookupAAS(aasId);
        if (aasDescriptor == null) {
            throw new ResourceNotFoundException("Specified AASId '" + aasId.getId() + "' does not exist.");
        }
        SubmodelDescriptor smDescriptor = aasDescriptor.getSubmodelDescriptorFromIdentifierId(smId);
        if (smDescriptor == null) {
            throw new ResourceNotFoundException("Specified SMId '" + smId + "' for AAS " + aasId.getId() + " does not exist.");
        }
        return smDescriptor;
    }
}

