/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.directory.tagged.authorized.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.IAASTaggedDirectory;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedSubmodelDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.authorized.internal.ITaggedDirectoryAuthorizer;
import org.eclipse.basyx.extensions.aas.registration.authorization.internal.AuthorizedAASRegistry;
import org.eclipse.basyx.extensions.shared.authorization.internal.ElevatedCodeAuthentication;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.NotAuthorizedException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizedTaggedDirectory<SubjectInformationType>
extends AuthorizedAASRegistry<SubjectInformationType>
implements IAASTaggedDirectory {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizedTaggedDirectory.class);
    private IAASTaggedDirectory decoratedTaggedDirectory;
    protected final ITaggedDirectoryAuthorizer<SubjectInformationType> taggedDirectoryAuthorizer;
    protected final ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider;

    public AuthorizedTaggedDirectory(IAASTaggedDirectory decoratedTaggedDirectory, ITaggedDirectoryAuthorizer<SubjectInformationType> taggedDirectoryAuthorizer, ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider) {
        super(decoratedTaggedDirectory, taggedDirectoryAuthorizer, subjectInformationProvider);
        this.decoratedTaggedDirectory = decoratedTaggedDirectory;
        this.taggedDirectoryAuthorizer = taggedDirectoryAuthorizer;
        this.subjectInformationProvider = subjectInformationProvider;
    }

    @Override
    public void register(TaggedAASDescriptor descriptor) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedRegistry.register(descriptor);
            return;
        }
        try {
            this.authorizeRegister(descriptor);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        try {
            super.authorizeRegister(descriptor);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedTaggedDirectory.register(descriptor);
    }

    protected void authorizeRegister(TaggedAASDescriptor descriptor) throws InhibitException {
        this.taggedDirectoryAuthorizer.authorizeRegister(this.subjectInformationProvider.get(), descriptor);
    }

    @Override
    public Set<TaggedAASDescriptor> lookupTag(String tag) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedTaggedDirectory.lookupTag(tag);
        }
        try {
            Set<TaggedAASDescriptor> taggedAASDescriptors = this.authorizeLookupTag(tag);
            return taggedAASDescriptors.stream().map(taggedAASDescriptor -> {
                try {
                    return super.authorizeLookupAAS(taggedAASDescriptor.getIdentifier());
                }
                catch (InhibitException e) {
                    logger.info(e.getMessage(), (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet()).stream().filter(TaggedAASDescriptor.class::isInstance).map(TaggedAASDescriptor.class::cast).collect(Collectors.toSet());
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected Set<TaggedAASDescriptor> authorizeLookupTag(String tag) throws InhibitException {
        Set<TaggedAASDescriptor> authorizedAASDescriptorsAfterLookupTag = this.taggedDirectoryAuthorizer.authorizeLookupTag(this.subjectInformationProvider.get(), tag, () -> this.decoratedTaggedDirectory.lookupTag(tag));
        Set authorizedAASDescriptorsAfterLookupAAS = authorizedAASDescriptorsAfterLookupTag.stream().map(aasDescriptor -> {
            try {
                return this.authorizeLookupAAS(aasDescriptor.getIdentifier());
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()).stream().filter(TaggedAASDescriptor.class::isInstance).map(TaggedAASDescriptor.class::cast).collect(Collectors.toSet());
        return authorizedAASDescriptorsAfterLookupAAS.stream().map(aasDescriptor -> {
            List<SubmodelDescriptor> submodelDescriptorsToRemove = aasDescriptor.getSubmodelDescriptors().stream().map(submodelDescriptor -> {
                IIdentifier smId = submodelDescriptor.getIdentifier();
                try {
                    return this.authorizeLookupSubmodel(aasDescriptor.getIdentifier(), smId);
                }
                catch (InhibitException e) {
                    logger.info(e.getMessage(), (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            submodelDescriptorsToRemove.forEach(submodelDescriptor -> aasDescriptor.removeSubmodelDescriptor(submodelDescriptor.getIdentifier()));
            return aasDescriptor;
        }).collect(Collectors.toSet());
    }

    @Override
    public Set<TaggedAASDescriptor> lookupTags(Set<String> tags) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedTaggedDirectory.lookupTags(tags);
        }
        try {
            return this.authorizeLookupTags(tags);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    @Override
    public void registerSubmodel(IIdentifier aasId, TaggedSubmodelDescriptor smDescriptor) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedRegistry.register(aasId, smDescriptor);
            return;
        }
        try {
            this.authorizeRegisterSubmodel(aasId, smDescriptor);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        try {
            super.authorizeRegister(aasId, smDescriptor);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedTaggedDirectory.registerSubmodel(aasId, smDescriptor);
    }

    protected void authorizeRegisterSubmodel(IIdentifier aasId, TaggedSubmodelDescriptor smDescriptor) throws InhibitException {
        this.taggedDirectoryAuthorizer.authorizeRegisterSubmodel(this.subjectInformationProvider.get(), aasId, smDescriptor);
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupSubmodelTag(String submodelTag) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedTaggedDirectory.lookupSubmodelTag(submodelTag);
        }
        try {
            return this.authorizeLookupSubmodelTag(submodelTag);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected Set<TaggedSubmodelDescriptor> authorizeLookupSubmodelTag(String submodelTag) throws InhibitException {
        Set<TaggedSubmodelDescriptor> authorizedSubmodelDescriptorsAfterLookupTag = this.taggedDirectoryAuthorizer.authorizeLookupSubmodelTag(this.subjectInformationProvider.get(), submodelTag, () -> this.decoratedTaggedDirectory.lookupSubmodelTag(submodelTag));
        return authorizedSubmodelDescriptorsAfterLookupTag.stream().map(smDescriptor -> {
            try {
                return this.authorizeLookupSubmodel(new ModelUrn("*"), smDescriptor.getIdentifier());
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()).stream().filter(TaggedSubmodelDescriptor.class::isInstance).map(TaggedSubmodelDescriptor.class::cast).collect(Collectors.toSet());
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupSubmodelTags(Set<String> submodelTags) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedTaggedDirectory.lookupSubmodelTags(submodelTags);
        }
        try {
            return this.authorizeLookupSubmodelTags(submodelTags);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected Set<TaggedSubmodelDescriptor> authorizeLookupSubmodelTags(Set<String> submodelTags) throws InhibitException {
        Set<TaggedSubmodelDescriptor> authorizedTaggedSmDescriptorsByCollection = this.authorizeLookupSubmodelTagListOnly(submodelTags);
        Set authorizedTaggedSmDescriptorsByIndividual = submodelTags.stream().map(tag -> {
            try {
                return this.authorizeLookupSubmodelTag((String)tag);
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet<TaggedSubmodelDescriptor> authorizedTaggedAASDescriptors = new HashSet<TaggedSubmodelDescriptor>(authorizedTaggedSmDescriptorsByCollection);
        authorizedTaggedAASDescriptors.retainAll(authorizedTaggedSmDescriptorsByIndividual);
        return authorizedTaggedAASDescriptors;
    }

    private Set<TaggedSubmodelDescriptor> authorizeLookupSubmodelTagListOnly(Set<String> submodelTags) throws InhibitException {
        return this.taggedDirectoryAuthorizer.authorizeLookupSubmodelTags(this.subjectInformationProvider.get(), submodelTags, () -> this.decoratedTaggedDirectory.lookupSubmodelTags(submodelTags));
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupBothAasAndSubmodelTags(Set<String> aasTags, Set<String> submodelTags) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedTaggedDirectory.lookupSubmodelTags(submodelTags);
        }
        try {
            return this.authorizeLookupBothAasAndSubmodelTags(aasTags, submodelTags);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected Set<TaggedSubmodelDescriptor> authorizeLookupBothAasAndSubmodelTags(Set<String> aasTags, Set<String> submodelTags) throws InhibitException {
        Set<TaggedSubmodelDescriptor> authorizedTaggedSmDescriptorsByBothAasAndSubmodelTags = this.authorizeLookupBothAasAndSubmodelTagListOnly(aasTags, submodelTags);
        Set<TaggedSubmodelDescriptor> authorizedTaggedSmDescriptorsBySubmodelTags = this.authorizeLookupSubmodelTags(submodelTags);
        HashSet<TaggedSubmodelDescriptor> authorizedTaggedDescriptors = new HashSet<TaggedSubmodelDescriptor>(authorizedTaggedSmDescriptorsByBothAasAndSubmodelTags);
        authorizedTaggedDescriptors.retainAll(authorizedTaggedSmDescriptorsBySubmodelTags);
        return authorizedTaggedDescriptors;
    }

    private Set<TaggedSubmodelDescriptor> authorizeLookupBothAasAndSubmodelTagListOnly(Set<String> aasTags, Set<String> submodelTags) throws InhibitException {
        return this.taggedDirectoryAuthorizer.authorizeLookupBothAasAndSubmodelTags(this.subjectInformationProvider.get(), aasTags, submodelTags, () -> this.decoratedTaggedDirectory.lookupBothAasAndSubmodelTags(aasTags, submodelTags));
    }

    protected Set<TaggedAASDescriptor> authorizeLookupTags(Set<String> tags) throws InhibitException {
        Set<TaggedAASDescriptor> authorizedTaggedAASDescriptorsByCollection = this.authorizeLookupTagListOnly(tags);
        Set authorizedTaggedAASDescriptorsByIndividual = tags.stream().map(tag -> {
            try {
                return this.authorizeLookupTag((String)tag);
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet<TaggedAASDescriptor> authorizedTaggedAASDescriptors = new HashSet<TaggedAASDescriptor>(authorizedTaggedAASDescriptorsByCollection);
        authorizedTaggedAASDescriptors.retainAll(authorizedTaggedAASDescriptorsByIndividual);
        return authorizedTaggedAASDescriptors;
    }

    private Set<TaggedAASDescriptor> authorizeLookupTagListOnly(Set<String> tags) throws InhibitException {
        return this.taggedDirectoryAuthorizer.authorizeLookupTags(this.subjectInformationProvider.get(), tags, () -> this.decoratedTaggedDirectory.lookupTags(tags));
    }
}

