/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.connected.submodelelement.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.ConnectedSubmodelElement;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.operation.ConnectedAsyncInvocation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationCheckHelper;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationHelper;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.eclipse.basyx.submodel.restapi.operation.InvocationRequest;
import org.eclipse.basyx.submodel.restapi.operation.InvocationResponse;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;

public class ConnectedOperation
extends ConnectedSubmodelElement
implements IOperation {
    public static final int DEFAULT_ASYNC_TIMEOUT = 10000;

    public ConnectedOperation(VABElementProxy proxy) {
        super(proxy);
    }

    @Override
    public Collection<IOperationVariable> getInputVariables() {
        return Operation.createAsFacade(this.getElem()).getInputVariables();
    }

    @Override
    public Collection<IOperationVariable> getOutputVariables() {
        return Operation.createAsFacade(this.getElem()).getOutputVariables();
    }

    @Override
    public Collection<IOperationVariable> getInOutputVariables() {
        return Operation.createAsFacade(this.getElem()).getInOutputVariables();
    }

    @Override
    public Object invoke(Object ... params) {
        return this.invokeSimple(params);
    }

    @Override
    public SubmodelElement[] invoke(SubmodelElement ... elems) {
        InvocationRequest request = this.createInvocationRequest(10000, elems);
        Object responseObj = this.getProxy().invokeOperation("invoke", request);
        InvocationResponse response = InvocationResponse.createAsFacade((Map)responseObj);
        Collection<IOperationVariable> outputArguments = response.getOutputArguments();
        List<SubmodelElement> elements = outputArguments.stream().map(IOperationVariable::getValue).collect(Collectors.toList());
        SubmodelElement[] result = new SubmodelElement[elements.size()];
        elements.toArray(result);
        return result;
    }

    private InvocationRequest createInvocationRequest(int timeout, SubmodelElement ... elems) {
        Collection inputArguments = Arrays.asList(elems).stream().map(OperationVariable::new).collect(Collectors.toList());
        String requestId = UUID.randomUUID().toString();
        return new InvocationRequest(requestId, new ArrayList<IOperationVariable>(), inputArguments, timeout);
    }

    @Override
    public ConnectedAsyncInvocation invokeAsync(Object ... params) {
        return this.invokeAsyncWithTimeout(10000, params);
    }

    @Override
    public ConnectedAsyncInvocation invokeAsyncWithTimeout(int timeout, Object ... params) {
        OperationCheckHelper.checkValidParameterLength(params.length, this.getIdShort(), this.getInputVariables());
        SubmodelElement[] smElements = OperationHelper.wrapParameters(this.getInputVariables(), params);
        InvocationRequest request = this.createInvocationRequest(timeout, smElements);
        return new ConnectedAsyncInvocation(this.getProxy(), this.getIdShort(), request);
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.OPERATION;
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("An Operation has no value");
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("An Operation has no value");
    }

    @Override
    public Operation getLocalCopy() {
        return Operation.createAsFacade(this.getElem()).getLocalCopy();
    }

    @Override
    public Object invokeSimple(Object ... params) {
        OperationCheckHelper.checkValidParameterLength(params.length, this.getIdShort(), this.getInputVariables());
        OperationCheckHelper.checkSubmodelElementExpectedTypes(params, this.getInputVariables());
        SubmodelElement[] wrapper = OperationHelper.wrapParameters(this.getInputVariables(), params);
        SubmodelElement[] result = this.invoke(wrapper);
        return OperationHelper.unwrapResult(result);
    }
}

