/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement;

import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IReferenceElement;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement;

public class ReferenceElement
extends DataElement
implements IReferenceElement {
    public static final String MODELTYPE = "ReferenceElement";

    public ReferenceElement() {
        this.putAll(new ModelType(MODELTYPE));
    }

    public ReferenceElement(String idShort) {
        super(idShort);
        this.putAll(new ModelType(MODELTYPE));
    }

    public ReferenceElement(String idShort, Reference ref) {
        this(idShort);
        this.setValue(ref);
    }

    public ReferenceElement(Reference ref) {
        this.putAll(new ModelType(MODELTYPE));
        this.put("value", ref);
    }

    public static ReferenceElement createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        ReferenceElement ret = new ReferenceElement();
        ret.setMap(obj);
        return ret;
    }

    public static boolean isReferenceElement(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey("value") && !map.containsKey("valueType") && !map.containsKey("valueId") && !map.containsKey("mimeType") && !map.containsKey("ordered") && !map.containsKey("allowDuplicates");
    }

    @Override
    public IReference getValue() {
        return Reference.createAsFacade((Map)this.get("value"));
    }

    @Override
    public void setValue(Object value) {
        if (!Reference.isReference(value)) {
            throw new IllegalArgumentException("Given Object is not a Reference");
        }
        this.setValue(Reference.createAsFacade((Map)value));
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.REFERENCEELEMENT;
    }

    @Override
    public ReferenceElement getLocalCopy() {
        ReferenceElement copy = new ReferenceElement();
        copy.putAll(this);
        return copy;
    }

    @Override
    public void setValue(IReference value) {
        this.put("value", value);
    }
}

