/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.address;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IMultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.address.Email;
import org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.address.Fax;
import org.eclipse.basyx.submodel.types.digitalnameplate.submodelelementcollections.address.Phone;
import org.eclipse.basyx.submodel.types.helper.SubmodelElementRetrievalHelper;

public class Address
extends SubmodelElementCollection {
    public static final String DEPARTMENTID = "Department";
    public static final String STREETID = "Street";
    public static final String ZIPCODEID = "Zipcode";
    public static final String POBOXID = "POBox";
    public static final String ZIPCODEOFPOBOXID = "ZipCodeOfPOBox";
    public static final String CITYTOWNID = "CityTown";
    public static final String STATECOUNTYID = "StateCounty";
    public static final String NATIONALCODEID = "NationalCode";
    public static final String VATNUMBERID = "VATNumber";
    public static final String ADDRESSREMARKSID = "AddressRemarks";
    public static final String ADDRESSOFADDITIONALLINKID = "AddressOfAdditionalLink";
    public static final String PHONEPREFIX = "Phone";
    public static final String FAXPREFIX = "Fax";
    public static final String EMAILPREFIX = "Email";
    public static final Reference SEMANTICID = new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAQ832#005", KeyType.IRDI));
    public static final String ADDRESSIDSHORT = "Address";

    private Address() {
    }

    public Address(MultiLanguageProperty street, MultiLanguageProperty zipCode, MultiLanguageProperty cityTown, MultiLanguageProperty nationalCode) {
        this(ADDRESSIDSHORT, street, zipCode, cityTown, nationalCode);
    }

    public Address(LangString street, LangString zipCode, LangString cityTown, LangString nationalCode) {
        this(ADDRESSIDSHORT, street, zipCode, cityTown, nationalCode);
    }

    public Address(String idShort, MultiLanguageProperty street, MultiLanguageProperty zipCode, MultiLanguageProperty cityTown, MultiLanguageProperty nationalCode) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setStreet(street);
        this.setZipCode(zipCode);
        this.setCityTown(cityTown);
        this.setNationalCode(nationalCode);
    }

    public Address(String idShort, LangString street, LangString zipCode, LangString cityTown, LangString nationalCode) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setStreet(street);
        this.setZipCode(zipCode);
        this.setCityTown(cityTown);
        this.setNationalCode(nationalCode);
    }

    public static Address createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Address.isValid(obj)) {
            throw new MetamodelConstructionException(Address.class, obj);
        }
        Address address = new Address();
        address.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return address;
    }

    private static Address createAsFacadeNonStrict(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        Address address = new Address();
        address.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return address;
    }

    public static boolean isValid(Map<String, Object> obj) {
        Address address = Address.createAsFacadeNonStrict(obj);
        return SubmodelElementCollection.isValid(obj) && MultiLanguageProperty.isValid((Map)((Object)address.getStreet())) && MultiLanguageProperty.isValid((Map)((Object)address.getZipCode())) && MultiLanguageProperty.isValid((Map)((Object)address.getCityTown())) && MultiLanguageProperty.isValid((Map)((Object)address.getNationalCode()));
    }

    public IMultiLanguageProperty getDepartment() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(DEPARTMENTID)));
    }

    public void setDepartment(MultiLanguageProperty department) {
        this.addSubmodelElement(department);
    }

    public void setDepartment(LangString department) {
        MultiLanguageProperty deptProp = new MultiLanguageProperty(DEPARTMENTID);
        deptProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO127#003", IdentifierType.IRDI)));
        deptProp.setValue(new LangStrings(department));
        this.setDepartment(deptProp);
    }

    public IMultiLanguageProperty getStreet() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(STREETID)));
    }

    public void setStreet(MultiLanguageProperty street) {
        this.addSubmodelElement(street);
    }

    public void setStreet(LangString street) {
        MultiLanguageProperty streetProp = new MultiLanguageProperty(STREETID);
        streetProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO128#002", IdentifierType.IRDI)));
        streetProp.setValue(new LangStrings(street));
        this.setStreet(streetProp);
    }

    public IMultiLanguageProperty getZipCode() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(ZIPCODEID)));
    }

    public void setZipCode(MultiLanguageProperty zipCode) {
        this.addSubmodelElement(zipCode);
    }

    public void setZipCode(LangString zipCode) {
        MultiLanguageProperty zipCodeProp = new MultiLanguageProperty(ZIPCODEID);
        zipCodeProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO129#002", IdentifierType.IRDI)));
        zipCodeProp.setValue(new LangStrings(zipCode));
        this.setZipCode(zipCodeProp);
    }

    public IMultiLanguageProperty getPOBox() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(POBOXID)));
    }

    public void setPOBox(MultiLanguageProperty poBox) {
        this.addSubmodelElement(poBox);
    }

    public void setPOBox(LangString poBox) {
        MultiLanguageProperty poBoxProp = new MultiLanguageProperty(POBOXID);
        poBoxProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO130#002", IdentifierType.IRDI)));
        poBoxProp.setValue(new LangStrings(poBox));
        this.setPOBox(poBoxProp);
    }

    public IMultiLanguageProperty getZipCodeOfPOBox() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(ZIPCODEOFPOBOXID)));
    }

    public void setZipCodeOfPOBox(MultiLanguageProperty zipCodeOfPoBox) {
        this.addSubmodelElement(zipCodeOfPoBox);
    }

    public void setZipCodeOfPOBox(LangString zipCodeOfPoBox) {
        MultiLanguageProperty zipCodeOfPoBoxProp = new MultiLanguageProperty(ZIPCODEOFPOBOXID);
        zipCodeOfPoBoxProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO131#002", IdentifierType.IRDI)));
        zipCodeOfPoBoxProp.setValue(new LangStrings(zipCodeOfPoBox));
        this.setZipCodeOfPOBox(zipCodeOfPoBoxProp);
    }

    public IMultiLanguageProperty getCityTown() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(CITYTOWNID)));
    }

    public void setCityTown(MultiLanguageProperty cityTown) {
        this.addSubmodelElement(cityTown);
    }

    public void setCityTown(LangString cityTown) {
        MultiLanguageProperty cityTownProp = new MultiLanguageProperty(CITYTOWNID);
        cityTownProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO132#002", IdentifierType.IRDI)));
        cityTownProp.setValue(new LangStrings(cityTown));
        this.setCityTown(cityTownProp);
    }

    public IMultiLanguageProperty getStateCounty() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(STATECOUNTYID)));
    }

    public void setStateCounty(MultiLanguageProperty stateCounty) {
        this.addSubmodelElement(stateCounty);
    }

    public void setStateCounty(LangString stateCounty) {
        MultiLanguageProperty stateCountyProp = new MultiLanguageProperty(STATECOUNTYID);
        stateCountyProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO133#002", IdentifierType.IRDI)));
        stateCountyProp.setValue(new LangStrings(stateCounty));
        this.setStateCounty(stateCountyProp);
    }

    public IMultiLanguageProperty getNationalCode() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(NATIONALCODEID)));
    }

    public void setNationalCode(MultiLanguageProperty nationalCode) {
        this.addSubmodelElement(nationalCode);
    }

    public void setNationalCode(LangString nationalCode) {
        MultiLanguageProperty nationalCodeProp = new MultiLanguageProperty(NATIONALCODEID);
        nationalCodeProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO134#002", IdentifierType.IRDI)));
        nationalCodeProp.setValue(new LangStrings(nationalCode));
        this.setNationalCode(nationalCodeProp);
    }

    public IMultiLanguageProperty getVatNumber() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(VATNUMBERID)));
    }

    public void setVatNumber(MultiLanguageProperty vatNumber) {
        this.addSubmodelElement(vatNumber);
    }

    public void setVatNumber(LangString vatNumber) {
        MultiLanguageProperty vatNumberProp = new MultiLanguageProperty(VATNUMBERID);
        vatNumberProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO135#002", IdentifierType.IRDI)));
        vatNumberProp.setValue(new LangStrings(vatNumber));
        this.setVatNumber(vatNumberProp);
    }

    public IMultiLanguageProperty getAddressRemarks() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(ADDRESSREMARKSID)));
    }

    public void setAddressRemarks(MultiLanguageProperty addressRemarks) {
        this.addSubmodelElement(addressRemarks);
    }

    public void setAddressRemarks(LangString addressRemarks) {
        MultiLanguageProperty addressRemarksProp = new MultiLanguageProperty(ADDRESSREMARKSID);
        addressRemarksProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAO202#003", IdentifierType.IRDI)));
        addressRemarksProp.setValue(new LangStrings(addressRemarks));
        this.setAddressRemarks(addressRemarksProp);
    }

    public IProperty getAddressOfAdditionalLink() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(ADDRESSOFADDITIONALLINKID)));
    }

    public void setAddressOfAdditionalLink(Property addressOfAdditionalLink) {
        this.addSubmodelElement(addressOfAdditionalLink);
    }

    public void setAddressOfAdditionalLink(String addressOfAdditionalLink) {
        Property addressOfAdditionalLinkProp = new Property(ADDRESSOFADDITIONALLINKID, ValueType.String);
        addressOfAdditionalLinkProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "0173-1#02-AAQ326#002", IdentifierType.IRDI)));
        addressOfAdditionalLinkProp.setValue(addressOfAdditionalLink);
        this.setAddressOfAdditionalLink(addressOfAdditionalLinkProp);
    }

    public List<Phone> getPhone() {
        ArrayList<Phone> ret = new ArrayList<Phone>();
        List<ISubmodelElement> elements = SubmodelElementRetrievalHelper.getSubmodelElementsByIdPrefix(PHONEPREFIX, this.getSubmodelElements());
        for (ISubmodelElement element : elements) {
            ret.add(Phone.createAsFacade((Map)((Object)element)));
        }
        return ret;
    }

    public void setPhone(List<Phone> phones) {
        if (phones != null && phones.size() > 0) {
            for (Phone phone : phones) {
                this.addSubmodelElement(phone);
            }
        }
    }

    public List<Fax> getFax() {
        ArrayList<Fax> ret = new ArrayList<Fax>();
        List<ISubmodelElement> elements = SubmodelElementRetrievalHelper.getSubmodelElementsByIdPrefix(FAXPREFIX, this.getSubmodelElements());
        for (ISubmodelElement element : elements) {
            ret.add(Fax.createAsFacade((Map)((Object)element)));
        }
        return ret;
    }

    public void setFax(List<Fax> faxes) {
        if (faxes != null && faxes.size() > 0) {
            for (Fax fax : faxes) {
                this.addSubmodelElement(fax);
            }
        }
    }

    public List<Email> getEmail() {
        ArrayList<Email> ret = new ArrayList<Email>();
        List<ISubmodelElement> elements = SubmodelElementRetrievalHelper.getSubmodelElementsByIdPrefix(EMAILPREFIX, this.getSubmodelElements());
        for (ISubmodelElement element : elements) {
            ret.add(Email.createAsFacade((Map)((Object)element)));
        }
        return ret;
    }

    public void setEmail(List<Email> emails) {
        if (emails != null && emails.size() > 0) {
            for (Email email : emails) {
                this.addSubmodelElement(email);
            }
        }
    }
}

