/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.opcua.types;

import java.util.Objects;
import java.util.UUID;
import org.eclipse.basyx.vab.protocol.opcua.exception.OpcUaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public final class NodeId {
    private final org.eclipse.milo.opcua.stack.core.types.builtin.NodeId internalId;
    private String cachedStringRepresentation;

    public NodeId(int namespaceIndex, long identifier) {
        if (identifier < 0L) {
            throw new IllegalArgumentException("Numeric identifier must not be negative.");
        }
        this.internalId = new org.eclipse.milo.opcua.stack.core.types.builtin.NodeId(namespaceIndex, UInteger.valueOf((long)identifier));
    }

    public NodeId(int namespaceIndex, String identifier) {
        Objects.requireNonNull(identifier);
        if (identifier.length() > 4096) {
            throw new IllegalArgumentException("String identifier must not be longer than 4096 characters.");
        }
        this.internalId = new org.eclipse.milo.opcua.stack.core.types.builtin.NodeId(namespaceIndex, identifier);
    }

    public NodeId(int namespaceIndex, UUID identifier) {
        Objects.requireNonNull(identifier);
        this.internalId = new org.eclipse.milo.opcua.stack.core.types.builtin.NodeId(namespaceIndex, identifier);
    }

    public NodeId(int namespaceIndex, byte[] identifier) {
        Objects.requireNonNull(identifier);
        if (identifier.length > 4096) {
            throw new IllegalArgumentException("ByteString identifier must not be longer than 4096 bytes.");
        }
        this.internalId = new org.eclipse.milo.opcua.stack.core.types.builtin.NodeId(namespaceIndex, ByteString.of((byte[])identifier));
    }

    public NodeId(org.eclipse.milo.opcua.stack.core.types.builtin.NodeId miloId) {
        this.internalId = miloId;
    }

    public static NodeId parse(String s) {
        try {
            org.eclipse.milo.opcua.stack.core.types.builtin.NodeId miloId = org.eclipse.milo.opcua.stack.core.types.builtin.NodeId.parse((String)s);
            return new NodeId(miloId);
        }
        catch (UaRuntimeException e) {
            throw new OpcUaException(e);
        }
    }

    public static NodeId tryParse(String s) {
        org.eclipse.milo.opcua.stack.core.types.builtin.NodeId miloId = org.eclipse.milo.opcua.stack.core.types.builtin.NodeId.parseOrNull((String)s);
        return miloId != null ? new NodeId(miloId) : null;
    }

    public org.eclipse.milo.opcua.stack.core.types.builtin.NodeId getInternalId() {
        return this.internalId;
    }

    public int getNamespaceIndex() {
        return this.internalId.getNamespaceIndex().intValue();
    }

    public Object getIdentifier() {
        switch (this.internalId.getType()) {
            case Opaque: {
                return ((ByteString)this.internalId.getIdentifier()).bytes();
            }
            case Numeric: {
                return ((UInteger)this.internalId.getIdentifier()).longValue();
            }
        }
        return this.internalId.getIdentifier();
    }

    public String toString() {
        if (this.cachedStringRepresentation == null) {
            this.cachedStringRepresentation = this.internalId.toParseableString();
        }
        return this.cachedStringRepresentation;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NodeId)) {
            return false;
        }
        NodeId other = (NodeId)obj;
        return this.internalId.equals((Object)other.internalId);
    }

    public int hashCode() {
        return this.internalId.hashCode();
    }
}

