/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.opcua.types;

import java.math.BigInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public final class UnsignedInteger {
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final UnsignedInteger MIN = new UnsignedInteger(UInteger.MIN);
    public static final UnsignedInteger MAX = new UnsignedInteger(UInteger.MAX);
    private final UInteger value;

    public UnsignedInteger(int value) throws NumberFormatException {
        this.value = UInteger.valueOf((int)value);
    }

    public UnsignedInteger(long value) throws NumberFormatException {
        this.value = UInteger.valueOf((long)value);
    }

    public UnsignedInteger(String value) throws NumberFormatException {
        this.value = UInteger.valueOf((String)value);
    }

    public UnsignedInteger(UInteger value) {
        this.value = value;
    }

    public UInteger getInternalValue() {
        return this.value;
    }

    public UnsignedInteger add(UnsignedInteger other) throws NumberFormatException {
        return new UnsignedInteger(this.value.add(other.toInt()));
    }

    public UnsignedInteger add(int other) throws NumberFormatException {
        return new UnsignedInteger(this.value.add(other));
    }

    public UnsignedInteger subtract(UnsignedInteger other) throws NumberFormatException {
        return new UnsignedInteger(this.value.subtract(other.toInt()));
    }

    public UnsignedInteger subtract(int other) throws NumberFormatException {
        return new UnsignedInteger(this.value.subtract(other));
    }

    public int toInt() {
        return this.value.intValue();
    }

    public long toLong() {
        return this.value.longValue();
    }

    public BigInteger toBigInteger() {
        return this.value.toBigInteger();
    }
}

