/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestInteractiveAuthenticator;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.auth.manager.UsernamePasswordAuthenticationProvider;

@PluggableService
public class UsernamePasswordInteractiveLogin
implements HttpRequestInteractiveAuthenticator {
    private static final HttpRequestInteractiveAuthenticator.LogoutHandler LOGOUT_HANDLER = response -> response.sendRedirect("/logout.html");

    @Override
    public HttpRequestInteractiveAuthenticator.AuthenticationHandler getAuthenticationHandler(HttpServletRequest request, HttpManagementConfiguration configuration) {
        if (configuration.getAuthenticationProvider(request) instanceof UsernamePasswordAuthenticationProvider) {
            return response -> request.getRequestDispatcher("/index.html").forward((ServletRequest)request, (ServletResponse)response);
        }
        return null;
    }

    @Override
    public HttpRequestInteractiveAuthenticator.LogoutHandler getLogoutHandler(HttpServletRequest request, HttpManagementConfiguration configuration) {
        if (configuration.getAuthenticationProvider(request) instanceof UsernamePasswordAuthenticationProvider) {
            return LOGOUT_HANDLER;
        }
        return null;
    }

    public String getType() {
        return "UsernamePassword";
    }
}

