/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFinder;

public class StructureServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException, ServletException {
        this.sendJsonResponse(this.generateStructure(managedObject, managedObject.getCategoryClass(), true), request, response);
    }

    private Map<String, Object> generateStructure(ConfiguredObject<?> object, Class<? extends ConfiguredObject> clazz, boolean includeAssociated) {
        LinkedHashMap<String, Object> structure = new LinkedHashMap<String, Object>();
        structure.put("id", object.getId());
        structure.put("name", object.getName());
        for (Class childClass : object.getModel().getChildTypes(clazz)) {
            this.addChildrenToStructure(structure, childClass, object.getChildren(childClass));
        }
        if (includeAssociated) {
            ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(object);
            for (Class childClass : finder.getAssociatedChildCategories()) {
                this.addChildrenToStructure(structure, childClass, finder.getAssociatedChildren(childClass));
            }
        }
        return structure;
    }

    private void addChildrenToStructure(Map<String, Object> structure, Class<? extends ConfiguredObject> childClass, Collection<? extends ConfiguredObject> children) {
        if (children != null) {
            ArrayList<Map<String, Object>> childObjects = new ArrayList<Map<String, Object>>();
            for (ConfiguredObject configuredObject : children) {
                childObjects.add(this.generateStructure(configuredObject, childClass, false));
            }
            if (!childObjects.isEmpty()) {
                structure.put(this.pluralize(childClass), childObjects);
            }
        }
    }

    private String pluralize(Class<? extends ConfiguredObject> childClass) {
        String name;
        return name + ((name = childClass.getSimpleName().toLowerCase()).endsWith("s") ? "es" : "s");
    }
}

