/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.authorization.internal;

import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedAASRegistryDecorator;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedAASRegistryFeature;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedTaggedDirectoryDecorator;
import org.eclipse.basyx.components.security.authorization.internal.AuthorizationDynamicClassLoader;
import org.eclipse.basyx.extensions.aas.directory.tagged.authorized.internal.GrantedAuthorityTaggedDirectoryAuthorizer;
import org.eclipse.basyx.extensions.aas.registration.authorization.internal.GrantedAuthorityAASRegistryAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.IGrantedAuthorityAuthenticator;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrantedAuthorityAuthorizedAASRegistryFeature<SubjectInformationType>
extends AuthorizedAASRegistryFeature {
    private static Logger logger = LoggerFactory.getLogger(GrantedAuthorityAuthorizedAASRegistryFeature.class);

    public GrantedAuthorityAuthorizedAASRegistryFeature(BaSyxSecurityConfiguration securityConfig) {
        super(securityConfig);
    }

    @Override
    public AuthorizedAASRegistryDecorator<SubjectInformationType> getAASRegistryDecorator() {
        logger.info("use GrantedAuthority authorization strategy");
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getGrantedAuthoritySubjectInformationProvider();
        IGrantedAuthorityAuthenticator<SubjectInformationType> grantedAuthorityAuthenticator = this.getGrantedAuthorityAuthenticator();
        return new AuthorizedAASRegistryDecorator<SubjectInformationType>(new GrantedAuthorityAASRegistryAuthorizer(grantedAuthorityAuthenticator), subjectInformationProvider);
    }

    @Override
    public AuthorizedTaggedDirectoryDecorator<SubjectInformationType> getTaggedDirectoryDecorator() {
        logger.info("use GrantedAuthority authorization strategy");
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getGrantedAuthoritySubjectInformationProvider();
        IGrantedAuthorityAuthenticator<SubjectInformationType> grantedAuthorityAuthenticator = this.getGrantedAuthorityAuthenticator();
        return new AuthorizedTaggedDirectoryDecorator<SubjectInformationType>(new GrantedAuthorityTaggedDirectoryAuthorizer(grantedAuthorityAuthenticator), subjectInformationProvider);
    }

    private IGrantedAuthorityAuthenticator<SubjectInformationType> getGrantedAuthorityAuthenticator() {
        return (IGrantedAuthorityAuthenticator)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.grantedAuthority.grantedAuthorityAuthenticator", IGrantedAuthorityAuthenticator.class);
    }

    private ISubjectInformationProvider<SubjectInformationType> getGrantedAuthoritySubjectInformationProvider() {
        return (ISubjectInformationProvider)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.grantedAuthority.subjectInformationProvider", ISubjectInformationProvider.class);
    }
}

