/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import java.nio.charset.Charset;

public class JsonPayloadCodec
implements ProtocolServerBuilder.PayloadCodec {
    private Charset charset = Charset.forName("UTF-8");

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Schema intendedSchema() {
        return Schema.TCP;
    }

    @Override
    public byte[] encode(String info, byte[] payload) {
        Payload pl = new Payload();
        pl.setInfo(info);
        pl.setPayload(payload);
        return JsonUtils.toJson((Object)pl).getBytes();
    }

    @Override
    public int getDataBytesLength() {
        return 0;
    }

    @Override
    public int decodeDataLength(byte[] data) {
        return 0;
    }

    @Override
    public void decode(byte[] data, ProtocolServerBuilder.PayloadConsumer consumer) {
        Payload pl = (Payload)JsonUtils.fromJson((Object)new String(data), Payload.class);
        consumer.decoded(pl.getInfo(), pl.getPayload());
    }

    public static class Payload {
        private String info;
        private byte[] payload;

        public String getInfo() {
            return this.info;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public byte[] getPayload() {
            return this.payload;
        }

        public void setPayload(byte[] payload) {
            this.payload = payload;
        }
    }
}

