/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import java.util.Locale;

public class LangString {
    private static String defaultLanguage = LangString.formatLanguage(Locale.getDefault().getLanguage());
    private String language;
    private String description;

    public LangString(String language, String description) {
        this.language = LangString.formatLanguage(language);
        this.description = description;
    }

    public static String formatLanguage(String language) {
        Object result = language;
        if (language != null && language.length() > 0 && Character.isUpperCase(language.charAt(0))) {
            result = String.valueOf(Character.toLowerCase(language.charAt(0)));
            if (language.length() > 1) {
                result = (String)result + language.substring(1);
            }
        }
        return result;
    }

    public static LangString create(String descLang) {
        String language;
        String description;
        int pos;
        if (null == descLang) {
            descLang = "";
        }
        if ((pos = descLang.lastIndexOf(64)) > 0 & pos < descLang.length()) {
            description = descLang.substring(0, pos);
            language = descLang.substring(pos + 1);
        } else {
            description = descLang;
            language = defaultLanguage;
        }
        return new LangString(language, description);
    }

    public static void setDefaultLanguage(String language) {
        defaultLanguage = language;
    }

    public static String getDefaultLanguage() {
        return defaultLanguage;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "[lang='" + this.language + "', desc='" + this.description + "']";
    }

    public int hashCode() {
        int result = null == this.getLanguage() ? 0 : this.getLanguage().hashCode();
        return result += null == this.getDescription() ? 0 : this.getDescription().hashCode();
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj instanceof LangString) {
            LangString ls = (LangString)obj;
            result = LangString.equalsSafe(this.getLanguage(), ls.getLanguage());
            result &= LangString.equalsSafe(this.getDescription(), ls.getDescription());
        } else {
            result = false;
        }
        return result;
    }

    private static boolean equalsSafe(String s1, String s2) {
        return null == s1 ? null == s2 : s1.equals(s2);
    }
}

