/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.identities;

import java.nio.charset.Charset;

public class IdentityToken {
    public static final String ENC_PLAIN_UTF_8 = "UTF-8";
    public static final String ENC_BCRYPT = "BCRYPT";
    public static final String ENC_SHA256 = "SHA256";
    private String tokenPolicyId;
    private TokenType type;
    private String userName;
    private byte[] tokenData;
    private String tokenEncryptionAlgorithm;
    private String signatureAlgorithm;
    private byte[] signature;

    protected IdentityToken(String tokenPolicyId, String signatureAlgorithm, byte[] signature) {
        this.tokenPolicyId = tokenPolicyId;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signature = signature;
    }

    protected IdentityToken(IdentityToken token) {
        this.tokenPolicyId = token.tokenPolicyId;
        this.type = token.type;
        this.userName = token.userName;
        this.tokenData = token.tokenData;
        this.tokenEncryptionAlgorithm = token.tokenEncryptionAlgorithm;
        this.signatureAlgorithm = token.signatureAlgorithm;
        this.signature = token.signature;
    }

    public String getTokenPolicyId() {
        return this.tokenPolicyId;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public TokenType getType() {
        return this.type;
    }

    public String getUserName() {
        return this.userName;
    }

    public byte[] getTokenData() {
        return this.tokenData;
    }

    public String getTokenDataAsString() {
        String result = null;
        if (null != this.tokenData) {
            for (Charset cs : Charset.availableCharsets().values()) {
                if (!cs.displayName().equals(this.tokenEncryptionAlgorithm)) continue;
                result = new String(this.tokenData, cs);
                break;
            }
            if (null == result) {
                result = new String(this.tokenData);
            }
        }
        return result;
    }

    public char[] getTokenDataAsCharArray() {
        String tokenData = this.getTokenDataAsString();
        return null == tokenData ? null : tokenData.toCharArray();
    }

    public String getTokenEncryptionAlgorithm() {
        return this.tokenEncryptionAlgorithm;
    }

    public String toString() {
        String result = "IdentityToken [" + String.valueOf((Object)this.type) + " ";
        switch (this.type.ordinal()) {
            case 3: {
                result = result + "user: " + this.getUserName();
                break;
            }
        }
        return result + "]";
    }

    public static enum TokenType {
        ANONYMOUS,
        ISSUED,
        X509,
        USERNAME;

    }

    public static class IdentityTokenBuilder {
        private IdentityToken token;

        private IdentityTokenBuilder() {
        }

        public static IdentityTokenBuilder newBuilder() {
            IdentityTokenBuilder builder = new IdentityTokenBuilder();
            builder.token = new IdentityToken(null, null, null);
            builder.token.type = TokenType.ANONYMOUS;
            return builder;
        }

        public static IdentityTokenBuilder newBuilder(String tokenPolicyId, String signatureAlgorithm, byte[] signature) {
            IdentityTokenBuilder builder = new IdentityTokenBuilder();
            builder.token = new IdentityToken(tokenPolicyId, signatureAlgorithm, signature);
            builder.token.type = TokenType.ANONYMOUS;
            return builder;
        }

        public IdentityTokenBuilder setIssuedToken(byte[] tokenData, String tokenEncryptionAlgorithm) {
            if (this.token.type == TokenType.ANONYMOUS) {
                this.token.type = TokenType.ISSUED;
                this.token.tokenData = tokenData;
                this.token.tokenEncryptionAlgorithm = tokenEncryptionAlgorithm;
            }
            return this;
        }

        public IdentityTokenBuilder setX509Token(byte[] tokenData) {
            if (this.token.type == TokenType.ANONYMOUS) {
                this.token.type = TokenType.X509;
                this.token.tokenData = tokenData;
            }
            return this;
        }

        public IdentityTokenBuilder setUsernameToken(String userName, byte[] tokenData, String tokenEncryptionAlgorithm) {
            if (this.token.type == TokenType.ANONYMOUS) {
                this.token.type = TokenType.USERNAME;
                this.token.userName = userName;
                this.token.tokenData = tokenData;
                this.token.tokenEncryptionAlgorithm = tokenEncryptionAlgorithm;
            }
            return this;
        }

        public IdentityToken build() {
            return this.token;
        }
    }
}

