/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.ValueConfigurer;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public class ParameterConfigurer<T>
implements ValueConfigurer<T> {
    private String name;
    private TypeTranslator<String, T> translator;
    private ValueConfigurer<T> cfg;
    private Supplier<T> getter;
    private Class<T> cls;
    private String sysProperty;

    public ParameterConfigurer(String name, Class<T> cls, TypeTranslator<String, T> translator, ValueConfigurer<T> cfg) {
        this(name, cls, translator, cfg, null);
    }

    public ParameterConfigurer(String name, Class<T> cls, TypeTranslator<String, T> translator, ValueConfigurer<T> cfg, Supplier<T> getter) {
        this.name = name;
        this.cls = cls;
        this.translator = translator;
        this.cfg = cfg;
        this.getter = getter;
    }

    public ParameterConfigurer<T> withSystemProperty(String sysProperty) {
        Object value;
        this.sysProperty = sysProperty;
        if (null != this.cfg && this.cls.isInstance(value = this.getValueFromSysProperty(null))) {
            try {
                this.configure(this.cls.cast(value));
                LoggerFactory.getLogger(ParameterConfigurer.class).info("Initialized parameter {} from system property {} with value {}", new Object[]{this.name, sysProperty, value});
            }
            catch (ExecutionException e) {
                LoggerFactory.getLogger(ParameterConfigurer.class).warn("Cannot initialize value from system property {}: {}", (Object)sysProperty, (Object)e.getMessage());
            }
        }
        return this;
    }

    @Override
    public void configure(T value) throws ExecutionException {
        this.cfg.configure(value);
    }

    public TypeTranslator<String, T> getTranslator() {
        return this.translator;
    }

    public Supplier<T> getGetter() {
        return this.getter;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.cls;
    }

    public void addValue(Map<String, String> values, Object value) {
        if (this.cls.isInstance(value = this.getValueFromSysProperty(value))) {
            try {
                values.put(this.name, (String)this.translator.from(this.cls.cast(value)));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(ParameterConfigurer.class).warn("Cannot add value for service parameter {}: {}", (Object)this.name, (Object)e.getMessage());
            }
        } else {
            LoggerFactory.getLogger(ParameterConfigurer.class).warn("Cannot add value for " + this.name + " as value is not instance of " + this.cls.getName());
        }
    }

    private Object getValueFromSysProperty(Object value) {
        String propValue;
        if (this.sysProperty != null && null != (propValue = System.getProperty(this.sysProperty, null))) {
            try {
                value = this.translator.to((Object)propValue);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(ParameterConfigurer.class).warn("Cannot convert system property {} to value of service parameter {}: {}. Ignoring system property.", new Object[]{this.sysProperty, this.name, e.getMessage()});
            }
        }
        return value;
    }
}

