/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.MeterRepresentation;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonArray;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonObjectBuilder;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.support.metrics.Statistic;
import java.util.ArrayList;
import java.util.List;

public class CounterRepresentation
extends MeterRepresentation
implements Counter {
    private double count;
    private double update;
    private List<Measurement> measurements;

    private CounterRepresentation(JsonObject object, String ... tags) {
        super(object, Meter.Type.COUNTER, tags);
        JsonArray ja = object.getJsonArray("measurements");
        JsonObject jo = ja.getJsonObject(0);
        if (ja.size() > 1 || Statistic.valueOf((String)jo.getString("statistic")) != Statistic.COUNT) {
            throw new IllegalArgumentException("This object does not map a valid Counter!");
        }
        this.count = jo.getJsonNumber("value").doubleValue();
        this.update = 0.0;
        this.measurements = new ArrayList<Measurement>();
        this.measurements.add(MetricsFactory.buildMeasurement(() -> this.count(), (Statistic)Statistic.COUNT));
    }

    private CounterRepresentation(String name) {
        super(name, Meter.Type.COUNTER);
        this.count = 0.0;
        this.update = 0.0;
        this.measurements = new ArrayList<Measurement>();
        this.measurements.add(MetricsFactory.buildMeasurement(() -> this.count, (Statistic)Statistic.COUNT));
    }

    public static Counter parseCounter(JsonObject object, String ... tags) {
        return new CounterRepresentation(object, tags);
    }

    public static Counter createNewCounter(String name) {
        return new CounterRepresentation(name);
    }

    public void increment(double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("Counters may never be reset to a lesser value!");
        }
        this.count += amount;
        this.update += amount;
    }

    public double count() {
        return this.count;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.measurements;
    }

    @Override
    public JsonObject getUpdater() {
        JsonObjectBuilder job = Json.createObjectBuilder();
        job.add("name", this.getId().getName());
        job.add("increment", this.update);
        return (JsonObject)job.build();
    }
}

