/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.services.TransportConverter;
import de.iip_ecosphere.platform.services.environment.services.TransportToAasConverter;
import de.iip_ecosphere.platform.services.environment.services.TransportToWsConverter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.services.environment.testing.DataRecorder;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.function.IOConsumer;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ApplicationSetup;
import de.iip_ecosphere.platform.support.iip_aas.PlatformAas;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.serialization.BasicSerializerProvider;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslators;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import de.iip_ecosphere.platform.transport.status.TraceRecordSerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class TraceToAasService
extends AbstractService {
    public static final String VERSION = "0.1.0";
    public static final String TRANSPORT_CHANNEL_PREFIX = "iip/";
    public static final String SUBMODEL_TRACES = "Traces";
    public static final String SUBMODEL_COMMANDS = "Commands";
    public static final String SUBMODEL_SERVICES = "Services";
    public static final String PROPERTY_SOURCE = "Source";
    public static final String PROPERTY_ACTION = "Action";
    public static final String PROPERTY_TIMESTAMP = "Timestamp";
    public static final String PROPERTY_PAYLOAD_TYPE = "PayloadType";
    public static final String PROPERTY_PAYLOAD = "Payload";
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap();
    private ApplicationSetup appSetup;
    private YamlArtifact artifact;
    private TransportConverter<TraceRecord> converter;
    private TransportConnector outTransport;
    private TransportParameter outTransportParameter;
    private DataRecorder recorder;
    private Server server;

    public TraceToAasService(ApplicationSetup app, YamlService yaml) {
        super(yaml);
        this.appSetup = new ApplicationSetup(app);
        this.addParameterConfigurer(new ParameterConfigurer<Long>("timeout", Long.class, TypeTranslators.LONG, t -> this.converter.setTimeout((long)t)));
        this.registerParameterConfigurers();
        this.recorder = this.createDataRecorder();
        TransportConverter.ConverterInstances<TraceRecord> inst = this.createConverter();
        this.converter = inst.getConverter();
        this.converter.setAasEnabledSupplier(() -> this.isAasEnabled());
        this.server = inst.getServer();
    }

    public TraceToAasService(String serviceId, InputStream ymlFile) {
        this(new YamlConstructionInfo(serviceId, ymlFile));
    }

    private TraceToAasService(YamlConstructionInfo info) {
        this(info.app, info.service);
    }

    public TraceToAasService(YamlArtifact artifact, String serviceId) {
        this(artifact.getApplication(), artifact.getService(serviceId));
        this.artifact = artifact;
    }

    public Server getGatewayServer() {
        return this.server;
    }

    protected void registerParameterConfigurers() {
    }

    protected DataRecorder createDataRecorder() {
        return this.createDataRecorderOrig();
    }

    protected final DataRecorder createDataRecorderOrig() {
        DataRecorder result = Starter.inTest() ? new DataRecorder(new File("target/recordings/appAas-" + this.getId() + "-recorded.txt"), DataRecorder.JSON_FORMATTER) : null;
        return result;
    }

    protected TransportConverter.ConverterInstances<TraceRecord> createConverter() {
        return TransportToWsConverter.createInstances("Trace", TraceRecord.class, this.getGatewayServer(), Starter.getSetup().getTransport(), this);
    }

    public void setTimeout(long timeout) {
        this.converter.setTimeout(timeout);
    }

    public void setCleanupTimeout(long cleanupTimeout) {
        this.converter.setCleanupTimeout(cleanupTimeout);
    }

    public boolean cleanup() {
        return this.converter.cleanup();
    }

    public ApplicationSetup getApplicationSetup() {
        return this.appSetup;
    }

    protected <T> void addParameterConfigurer(ParameterConfigurer<T> configurer) {
        if (null != configurer) {
            this.paramConfigurers.put(configurer.getName(), configurer);
        }
    }

    public String getAasId() {
        return AasUtils.fixId((String)("application_" + this.appSetup.getId()));
    }

    public String getAasUrn() {
        return "urn:::AAS:::" + this.getAasId() + "#";
    }

    protected boolean isAasEnabled() {
        return true;
    }

    protected String mapPayloadType(Class<?> cls) {
        return cls.getName();
    }

    protected String composeIdentifier(String specificId) {
        return AasUtils.composeIdentifier((String)this.getAasUrn(), (String)specificId);
    }

    @Override
    protected ServiceState start() throws ExecutionException {
        if (null != this.server) {
            this.server.start();
        }
        AasPartRegistry.AasSetup aasSetup = Starter.getSetup().getAas();
        new Thread(() -> {
            try {
                AuthenticationDescriptor aDesc = AasPartRegistry.getSubmodelAuthentication();
                AasFactory factory = AasFactory.getInstance();
                Aas.AasBuilder aasBuilder = factory.createAasBuilder(this.getAasId(), this.getAasUrn());
                Submodel.SubmodelBuilder smBuilder = PlatformAas.createNameplate((Aas.AasBuilder)aasBuilder, (ApplicationSetup)this.appSetup, (String)this.composeIdentifier("TD"));
                PlatformAas.addSoftwareInfo((Submodel.SubmodelBuilder)smBuilder, (ApplicationSetup)this.appSetup);
                smBuilder.build();
                smBuilder = (Submodel.SubmodelBuilder)aasBuilder.createSubmodelBuilder(SUBMODEL_COMMANDS, this.composeIdentifier("CMDS")).rbacPlatform(aDesc);
                this.augmentCommandsSubmodel(smBuilder);
                smBuilder.build();
                smBuilder = (Submodel.SubmodelBuilder)aasBuilder.createSubmodelBuilder(SUBMODEL_SERVICES, this.composeIdentifier("SVC")).rbacPlatform(aDesc);
                this.augmentServicesSubmodel(smBuilder);
                smBuilder.build();
                Submodel.SubmodelBuilder convSubmodel = (Submodel.SubmodelBuilder)aasBuilder.createSubmodelBuilder(SUBMODEL_TRACES, this.composeIdentifier("TRC")).rbacPlatform(aDesc);
                this.converter.initializeSubmodel(convSubmodel);
                convSubmodel.build();
                Aas aas = (Aas)aasBuilder.build();
                List aasList = CollectionUtils.addAll(new ArrayList(), (Object[])new Aas[]{aas});
                AasPartRegistry.remoteDeploy((AasPartRegistry.AasSetup)aasSetup, (List)aasList);
                this.converter.start(aasSetup);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Creating AAS: " + e.getMessage());
            }
        }).start();
        ServiceState result = super.start();
        this.outTransport = this.createTransport();
        if (null != this.outTransport) {
            this.converter.addNotifier((IOConsumer<TraceRecord>)((IOConsumer)d -> this.outTransport.asyncSend(this.getAasTransportChannel(), d)));
        }
        if (null != this.recorder) {
            this.converter.addNotifier((IOConsumer<TraceRecord>)((IOConsumer)d -> this.recorder.record(this.getAasTransportChannel(), d)));
        }
        return result;
    }

    protected void recordData(String channel, Object data) {
        if (null != this.recorder) {
            this.recorder.record(channel, data);
        }
    }

    @Override
    protected ServiceState stop() {
        ServiceState result = super.stop();
        if (null != this.recorder) {
            this.recorder.close();
        }
        this.converter.stop();
        Server.stop((Server)this.server, (boolean)true);
        return result;
    }

    public boolean isAasStarted() {
        return this.converter.isAasStarted();
    }

    protected String getAasTransportChannel() {
        Object appId = ServiceBase.getApplicationId(this.getId());
        if (((String)appId).length() > 0) {
            appId = "_" + (String)appId;
        }
        return TRANSPORT_CHANNEL_PREFIX + (String)appId + "/traces";
    }

    protected BasicSerializerProvider getConfiguredSerializationProvider() {
        BasicSerializerProvider result = new BasicSerializerProvider();
        result.registerSerializer((Serializer)new TraceRecordSerializer());
        return result;
    }

    public void setTransportParameter(TransportParameter transportParameter) {
        this.outTransportParameter = transportParameter;
    }

    protected TransportConnector createTransport() {
        return this.createTransport(this.getConfiguredSerializationProvider());
    }

    protected TransportConnector createTransport(BasicSerializerProvider serializationProvider) {
        return null;
    }

    protected TransportConnector getTransport() {
        return this.outTransport;
    }

    public TransportParameter getTransportParameter() {
        return this.outTransportParameter;
    }

    protected void sendTransportAsync(String channel, Object data) {
        if (null != this.outTransport) {
            try {
                this.outTransport.asyncSend(channel, data);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Cannot send to outTransport {}", (Object)e.getMessage());
            }
        }
    }

    private void augmentServicesSubmodel(Submodel.SubmodelBuilder smBuilder) {
        if (null != this.artifact) {
            AasFactory factory = AasFactory.getInstance();
            try {
                Registry reg = factory.obtainRegistry((SetupSpec)Starter.getSetup().getAas());
                for (YamlService s : this.artifact.getServices()) {
                    String ep = reg.getEndpoint(AasUtils.fixId((String)("service_" + s.getId())));
                    if (null == ep) {
                        ep = "";
                    }
                    smBuilder.createPropertyBuilder(AasUtils.fixId((String)s.getId())).setValue(Type.STRING, (Object)ep).build();
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Building services submodel: {}", (Object)e.getMessage());
            }
        }
    }

    protected void augmentCommandsSubmodel(Submodel.SubmodelBuilder smBuilder) {
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
    }

    @Override
    public void update(URI location) throws ExecutionException {
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
    }

    @Override
    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return this.paramConfigurers.get(paramName);
    }

    protected Aas retrieveAas() throws IOException {
        return AasPartRegistry.retrieveAas((AasPartRegistry.AasSetup)Starter.getSetup().getAas(), (String)this.getAasUrn());
    }

    public boolean isTraceInAas() {
        return this.converter.isTraceInAas();
    }

    private static class YamlConstructionInfo {
        private ApplicationSetup app;
        private YamlService service;

        protected YamlConstructionInfo(String serviceId, InputStream ymlFile) {
            YamlArtifact art = YamlArtifact.readFromYamlSafe(ymlFile);
            this.app = art.getApplication();
            this.service = art.getServiceSafe(serviceId);
        }
    }

    protected class Converter
    extends TransportToAasConverter<TraceRecord> {
        public Converter() {
            super(TraceToAasService.SUBMODEL_TRACES, "Trace", TraceRecord.class);
        }

        @Override
        public String getAasId() {
            return TraceToAasService.this.getAasId();
        }

        @Override
        public String getAasUrn() {
            return TraceToAasService.this.getAasUrn();
        }

        @Override
        protected Function<TraceRecord, String> getSubmodelElementIdFunction() {
            return data -> AasUtils.fixId((String)(data.getSource() + "_" + data.getTimestamp()));
        }

        @Override
        public TransportToAasConverter.CleanupPredicate getCleanupPredicate() {
            return (coll, timestamp) -> {
                boolean del = false;
                Property prop = coll.getProperty(TraceToAasService.PROPERTY_TIMESTAMP);
                if (null != prop) {
                    try {
                        Object val = prop.getValue();
                        if (val instanceof Integer) {
                            del = (long)((Integer)val).intValue() < timestamp;
                        } else if (val instanceof Long) {
                            del = (Long)val < timestamp;
                        }
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
                return del;
            };
        }

        @Override
        protected boolean cleanUpAas(Aas aas) {
            aas.delete(aas.getSubmodel("TechnicalData"));
            aas.delete(aas.getSubmodel(TraceToAasService.SUBMODEL_COMMANDS));
            return true;
        }

        @Override
        protected void populateSubmodelElementCollection(SubmodelElementContainerBuilder smcBuilder, TraceRecord data) {
            AuthenticationDescriptor aDesc = AasPartRegistry.getSubmodelAuthentication();
            smcBuilder.createPropertyBuilder(TraceToAasService.PROPERTY_SOURCE).setValue(Type.STRING, (Object)data.getSource()).build(aDesc);
            smcBuilder.createPropertyBuilder(TraceToAasService.PROPERTY_ACTION).setValue(Type.STRING, (Object)data.getAction()).build(aDesc);
            smcBuilder.createPropertyBuilder(TraceToAasService.PROPERTY_TIMESTAMP).setValue(Type.INT64, (Object)data.getTimestamp()).build(aDesc);
            if (null != data.getPayload()) {
                Class<?> cls = data.getPayload().getClass();
                smcBuilder.createPropertyBuilder(TraceToAasService.PROPERTY_PAYLOAD_TYPE).setValue(Type.STRING, (Object)this.mapPayloadType(cls)).build();
                SubmodelElementCollection.SubmodelElementCollectionBuilder payloadBuilder = smcBuilder.createSubmodelElementCollectionBuilder(TraceToAasService.PROPERTY_PAYLOAD);
                this.createPayloadEntries((SubmodelElementContainerBuilder)payloadBuilder, data.getPayload());
            }
        }

        @Override
        protected String mapPayloadType(Class<?> cls) {
            return TraceToAasService.this.mapPayloadType(cls);
        }

        @Override
        protected void doWatch(SubmodelElementCollection coll, long lastRun) {
            System.out.println(coll);
        }
    }
}

