/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.environment.services.Sender;
import de.iip_ecosphere.platform.services.environment.services.TransportConverter;
import de.iip_ecosphere.platform.services.environment.services.TransportConverterFactory;
import de.iip_ecosphere.platform.services.environment.services.WsTransportConverterFactory;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.serialization.GenericJsonToStringTranslator;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.util.Set;

public class TransportToWsConverter<T>
extends TransportConverter<T> {
    public static final Schema SCHEMA = Schema.WS;
    private Endpoint endpoint;
    private Sender<T> sender;
    private boolean notConnectedError = false;
    private TypeTranslator<T, String> typeTranslator;

    public TransportToWsConverter(String transportStream, Class<T> dataType, Endpoint endpoint) {
        this(transportStream, dataType, endpoint, null);
    }

    public TransportToWsConverter(String transportStream, Class<T> dataType, Endpoint endpoint, TypeTranslator<T, String> translator) {
        super(transportStream, dataType);
        this.endpoint = endpoint;
        this.typeTranslator = TransportConverterFactory.ensureTranslator(translator, dataType);
    }

    public static <T> TransportConverter.ConverterInstances<T> createInstances(String transportStream, Class<T> cls, Server server, TransportSetup setup, Service service) {
        Endpoint endpoint;
        String path = "/app_" + Starter.getServiceId(service);
        if (setup.isLocalGatewayEndpoint()) {
            endpoint = new Endpoint(SCHEMA, NetUtils.getOwnIP((String)setup.getNetmask()), NetUtils.getEphemeralPort(), path);
            if (null == server) {
                server = TransportToWsConverter.createServer((ServerAddress)endpoint);
            }
        } else {
            endpoint = TransportConverterFactory.getInstance().validateGatewayEndpoint(setup.getGatewayServerEndpoint(SCHEMA, path));
            server = null;
        }
        return new TransportConverter.ConverterInstances<T>(server, new TransportToWsConverter<T>(transportStream, cls, endpoint));
    }

    public static Server createServer(ServerAddress address) {
        return WsTransportConverterFactory.INSTANCE.createServer(address);
    }

    @Override
    public void setExcludedFields(Set<String> excludedFields) {
        super.setExcludedFields(excludedFields);
        if (this.typeTranslator instanceof GenericJsonToStringTranslator) {
            ((GenericJsonToStringTranslator)this.typeTranslator).getMapper().exceptFields(this.getExcludedFieldsArray());
        }
    }

    @Override
    public void initializeSubmodel(Submodel.SubmodelBuilder smBuilder) {
        TransportToWsConverter.addEndpointToAas((SubmodelElementContainerBuilder)smBuilder, this.endpoint);
    }

    @Override
    public void start(AasPartRegistry.AasSetup aasSetup) {
        super.start(aasSetup);
        if (this.isAasEnabled()) {
            this.sender = WsTransportConverterFactory.INSTANCE.createSender(this.endpoint, this.typeTranslator, this.getType());
            if (null != this.sender) {
                try {
                    this.sender.connectBlocking();
                }
                catch (IOException e) {
                    TransportToWsConverter.getLogger().error("Connection attempt interrupted: {}", (Object)e.getMessage());
                }
            }
        }
    }

    @Override
    public void stop() {
        if (null != this.sender) {
            this.sender.close();
        }
    }

    @Override
    protected void handleNew(T data) {
        if (null != this.sender) {
            try {
                this.sender.send(data);
                this.notConnectedError = false;
            }
            catch (IOException e) {
                if (!this.notConnectedError) {
                    TransportToWsConverter.getLogger().error("Cannot write data, not connected: {}", (Object)e.getMessage());
                    this.notConnectedError = true;
                }
                TransportToWsConverter.getLogger().error("Cannot write data: {}", (Object)e.getMessage());
            }
        }
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(TransportToWsConverter.class);
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public TransportConverter.Watcher<T> createWatcher(int period) {
        return WsTransportConverterFactory.INSTANCE.createWatcher(this.endpoint, this.typeTranslator, this.getType(), period);
    }

    public TypeTranslator<T, String> getTypeTranslator() {
        return this.typeTranslator;
    }
}

