/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.core.dataStructures.ConcurrentLongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogCache;
import org.jetbrains.annotations.NotNull;

final class SharedLogCache
extends LogCache {
    @NotNull
    private final LongObjectCacheBase<CachedValue> pagesCache;

    SharedLogCache(long memoryUsage, int pageSize, boolean nonBlocking) {
        super(memoryUsage, pageSize);
        int pagesCount = (int)(memoryUsage / (long)(pageSize + 96));
        this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(pagesCount, 2) : new LongObjectCache(pagesCount);
    }

    SharedLogCache(int memoryUsagePercentage, int pageSize, boolean nonBlocking) {
        super(memoryUsagePercentage, pageSize);
        if (this.memoryUsage == Long.MAX_VALUE) {
            this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(8192, 2) : new LongObjectCache();
        } else {
            int pagesCount = (int)(this.memoryUsage / (long)(pageSize + 96));
            this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(pagesCount, 2) : new LongObjectCache(pagesCount);
        }
    }

    @Override
    void clear() {
    }

    @Override
    float hitRate() {
        return this.pagesCache.hitRate();
    }

    @Override
    void cachePage(@NotNull Log log, long pageAddress, @NotNull byte[] page) {
        int logIdentity = log.getIdentity();
        this.cachePage(SharedLogCache.getLogPageFingerPrint(logIdentity, pageAddress), logIdentity, pageAddress, page);
    }

    @Override
    @NotNull
    byte[] getPage(@NotNull Log log, long pageAddress) {
        int logIdentity = log.getIdentity();
        long key = SharedLogCache.getLogPageFingerPrint(logIdentity, pageAddress);
        CachedValue cachedValue = (CachedValue)this.pagesCache.tryKeyLocked(key);
        if (cachedValue != null && cachedValue.logIdentity == logIdentity && cachedValue.address == pageAddress) {
            return cachedValue.page;
        }
        byte[] page = log.getHighPage(pageAddress);
        if (page != null) {
            return page;
        }
        page = this.readFullPage(log, pageAddress);
        this.cachePage(key, logIdentity, pageAddress, page);
        return page;
    }

    @Override
    @NotNull
    protected ArrayByteIterable getPageIterable(@NotNull Log log, long pageAddress) {
        int logIdentity = log.getIdentity();
        long key = SharedLogCache.getLogPageFingerPrint(logIdentity, pageAddress);
        CachedValue cachedValue = (CachedValue)this.pagesCache.tryKeyLocked(key);
        if (cachedValue != null && cachedValue.logIdentity == logIdentity && cachedValue.address == pageAddress) {
            return new ArrayByteIterable(cachedValue.page);
        }
        byte[] page = log.getHighPage(pageAddress);
        if (page != null) {
            return new ArrayByteIterable(page, (int)Math.min(log.getHighAddress() - pageAddress, (long)this.pageSize));
        }
        page = this.readFullPage(log, pageAddress);
        this.cachePage(key, logIdentity, pageAddress, page);
        return new ArrayByteIterable(page);
    }

    @Override
    protected void removePage(@NotNull Log log, long pageAddress) {
        long key = SharedLogCache.getLogPageFingerPrint(log.getIdentity(), pageAddress);
        try (LongObjectCacheBase.CriticalSection ignored = this.pagesCache.newCriticalSection();){
            this.pagesCache.remove(key);
        }
    }

    private void cachePage(long key, int logIdentity, long address, @NotNull byte[] page) {
        try (LongObjectCacheBase.CriticalSection ignored = this.pagesCache.newCriticalSection();){
            if (this.pagesCache.getObject(key) == null) {
                this.pagesCache.cacheObject(key, (Object)new CachedValue(logIdentity, address, SharedLogCache.postProcessTailPage(page)));
            }
        }
    }

    private static long getLogPageFingerPrint(int logIdentity, long address) {
        return (address + (long)logIdentity << 32) + address + (long)logIdentity;
    }

    private static final class CachedValue {
        private final int logIdentity;
        private final long address;
        private final byte[] page;

        CachedValue(int logIdentity, long address, @NotNull byte[] page) {
            this.logIdentity = logIdentity;
            this.address = address;
            this.page = page;
        }
    }
}

