/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.bindings.CompressedUnsignedLongArrayByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.SingleByteIterable;
import jetbrains.exodus.log.TooBigLoggableException;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.ChildReferenceMutable;
import jetbrains.exodus.tree.patricia.ChildReferenceSet;
import jetbrains.exodus.tree.patricia.ImmutableNode;
import jetbrains.exodus.tree.patricia.MutableNodeSaveContext;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.NodeChildren;
import jetbrains.exodus.tree.patricia.NodeChildrenIterator;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MutableNode
extends NodeBase {
    @NotNull
    protected final ChildReferenceSet children;

    MutableNode(@NotNull ImmutableNode origin) {
        super(origin.keySequence, origin.value);
        this.children = new ChildReferenceSet();
        this.copyChildrenFrom(origin);
    }

    MutableNode(@NotNull ByteIterable keySequence) {
        this(keySequence, null, new ChildReferenceSet());
    }

    protected MutableNode(@NotNull ByteIterable keySequence, @Nullable ByteIterable value, @NotNull ChildReferenceSet children) {
        super(keySequence, value);
        this.children = children;
    }

    void setKeySequence(@NotNull ByteIterable keySequence) {
        this.keySequence = keySequence;
    }

    void setValue(@Nullable ByteIterable value) {
        this.value = value;
    }

    @Override
    long getAddress() {
        return -1L;
    }

    @Override
    boolean isMutable() {
        return true;
    }

    @Override
    MutableNode getMutableCopy(@NotNull PatriciaTreeMutable mutableTree) {
        return this;
    }

    ChildReference getRef(int pos) {
        return this.children.referenceAt(pos);
    }

    @Override
    NodeBase getChild(@NotNull PatriciaTreeBase tree, byte b) {
        ChildReference ref = this.children.get(b);
        return ref == null ? null : ref.getNode(tree);
    }

    @Override
    @NotNull
    NodeChildren getChildren() {
        return new NodeChildren(){

            @Override
            public NodeChildrenIterator iterator() {
                return MutableNode.this.children.isEmpty() ? new NodeBase.EmptyNodeChildrenIterator(MutableNode.this) : new MutableNodeChildrenIterator(MutableNode.this, MutableNode.this.children);
            }
        };
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildren(byte b) {
        int index = this.children.searchFor(b);
        return index < 0 ? new NodeBase.EmptyNodeChildrenIterator(this) : new MutableNodeChildrenIterator(this, this.children.iterator(index));
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildrenLast() {
        return this.getChildren(this.children.size());
    }

    @NotNull
    NodeChildrenIterator getChildren(int pos) {
        return new MutableNodeChildrenIterator(this, this.children.iterator(pos));
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildrenRange(byte b) {
        if (this.children.isEmpty()) {
            return new NodeBase.EmptyNodeChildrenIterator(this);
        }
        int index = this.children.searchFor(b);
        if (index < 0) {
            index = -index - 1;
        }
        return new MutableNodeChildrenIterator(this, this.children.iterator(index));
    }

    @Override
    int getChildrenCount() {
        return this.children.size();
    }

    boolean hasChildren() {
        return !this.children.isEmpty();
    }

    void setChild(byte b, @NotNull MutableNode child) {
        int index = this.children.searchFor(b);
        if (index < 0) {
            this.children.insertAt(-index - 1, new ChildReferenceMutable(b, child));
        } else {
            ChildReference ref = this.children.referenceAt(index);
            if (ref.isMutable()) {
                ((ChildReferenceMutable)ref).child = child;
            } else {
                this.children.setAt(index, new ChildReferenceMutable(b, child));
            }
        }
    }

    void setChild(int index, @NotNull MutableNode child) {
        ChildReference ref = this.children.referenceAt(index);
        if (ref.isMutable()) {
            ((ChildReferenceMutable)ref).child = child;
        } else {
            this.children.setAt(index, new ChildReferenceMutable(ref.firstByte, child));
        }
    }

    NodeBase getRightChild(@NotNull PatriciaTreeBase tree, byte b) {
        ChildReference ref = this.children.getRight();
        if (ref == null) {
            return null;
        }
        int rightByte = b & 0xFF;
        int firstByte = ref.firstByte & 0xFF;
        if (rightByte < firstByte) {
            throw new IllegalArgumentException();
        }
        return rightByte > firstByte ? null : ref.getNode(tree);
    }

    void addRightChild(byte b, @NotNull MutableNode child) {
        ChildReference right = this.children.getRight();
        if (right != null && (right.firstByte & 0xFF) >= (b & 0xFF)) {
            throw new IllegalArgumentException();
        }
        this.children.putRight(new ChildReferenceMutable(b, child));
    }

    void setRightChild(byte b, @NotNull MutableNode child) {
        ChildReference right = this.children.getRight();
        if (right == null || (right.firstByte & 0xFF) != (b & 0xFF)) {
            throw new IllegalArgumentException();
        }
        this.children.setAt(this.children.size() - 1, new ChildReferenceMutable(b, child));
    }

    boolean removeChild(byte b) {
        return this.children.remove(b);
    }

    MutableNode splitKey(int prefixLength, byte nextByte) {
        byte[] keyBytes = this.keySequence.getBytesUnsafe();
        Object prefixKey = prefixLength == 0 ? ByteIterable.EMPTY : (prefixLength == 1 ? SingleByteIterable.getIterable(keyBytes[0]) : new ArrayByteIterable(keyBytes, prefixLength));
        MutableNode prefix = new MutableNode((ByteIterable)prefixKey);
        int suffixLength = this.keySequence.getLength() - prefixLength - 1;
        ByteIterable suffixKey = suffixLength == 0 ? ByteIterable.EMPTY : (suffixLength == 1 ? SingleByteIterable.getIterable(keyBytes[prefixLength + 1]) : this.keySequence.subIterable(prefixLength + 1, suffixLength));
        MutableNode suffix = new MutableNode(suffixKey, this.value, this.children);
        prefix.setChild(nextByte, suffix);
        return prefix;
    }

    MutableNode splitKey(int prefixLength, int nextByte) {
        return this.splitKey(prefixLength, (byte)nextByte);
    }

    void mergeWithSingleChild(@NotNull PatriciaTreeMutable tree) {
        ChildReference ref = (ChildReference)this.getChildren().iterator().next();
        NodeBase child = ref.getNode(tree);
        this.value = child.value;
        this.keySequence = new CompoundByteIterable(new ByteIterable[]{this.keySequence, SingleByteIterable.getIterable(ref.firstByte), child.keySequence});
        this.copyChildrenFrom(child);
    }

    MutableNode hang(byte firstByte, @NotNull ByteIterator tail) {
        MutableNode result = new MutableNode((ByteIterable)new ArrayByteIterable(tail));
        this.setChild(firstByte, result);
        return result;
    }

    MutableNode hang(int firstByte, @NotNull ByteIterator tail) {
        return this.hang((byte)firstByte, tail);
    }

    MutableNode hangRight(byte firstByte, @NotNull ByteIterator tail) {
        MutableNode result = new MutableNode((ByteIterable)new ArrayByteIterable(tail));
        this.addRightChild(firstByte, result);
        return result;
    }

    MutableNode hangRight(int firstByte, @NotNull ByteIterator tail) {
        return this.hangRight((byte)firstByte, tail);
    }

    long save(@NotNull PatriciaTreeMutable tree, @NotNull MutableNodeSaveContext context) {
        long result;
        int pos;
        Log log = tree.getLog();
        int bytesPerAddress = 0;
        for (ChildReference ref : this.children) {
            int logarithm;
            if (ref.isMutable()) {
                ref.suffixAddress = ((ChildReferenceMutable)ref).child.save(tree, context);
            }
            if ((logarithm = CompressedUnsignedLongArrayByteIterable.logarithm((long)ref.suffixAddress)) <= bytesPerAddress) continue;
            bytesPerAddress = logarithm;
        }
        int childrenCount = this.getChildrenCount();
        LightOutputStream nodeStream = context.newNodeStream();
        if (this.hasKey()) {
            CompressedUnsignedLongByteIterable.fillBytes(this.keySequence.getLength(), nodeStream);
            ByteIterableBase.fillBytes((ByteIterable)this.keySequence, (LightOutputStream)nodeStream);
        }
        if (this.hasValue()) {
            CompressedUnsignedLongByteIterable.fillBytes(this.value.getLength(), nodeStream);
            ByteIterableBase.fillBytes((ByteIterable)this.value, (LightOutputStream)nodeStream);
        }
        if (!this.children.isEmpty()) {
            CompressedUnsignedLongByteIterable.fillBytes((childrenCount << 3) + bytesPerAddress - 1, nodeStream);
            for (ChildReference ref : this.children) {
                nodeStream.write((int)ref.firstByte);
                LongBinding.writeUnsignedLong((long)ref.suffixAddress, (int)bytesPerAddress, (LightOutputStream)nodeStream);
            }
        }
        byte type = this.getLoggableType();
        int structureId = tree.getStructureId();
        ArrayByteIterable mainIterable = nodeStream.asArrayByteIterable();
        long startAddress = context.startAddress;
        if (!this.isRoot()) {
            long result2 = log.write(type, structureId, (ByteIterable)mainIterable);
            if (startAddress == -1L) {
                context.startAddress = result2;
            }
            return result2;
        }
        ByteIterable[] iterables = new ByteIterable[3];
        iterables[0] = context.preliminaryRootData;
        if (startAddress == -1L) {
            iterables[1] = mainIterable;
            long result3 = log.write(type, structureId, (ByteIterable)new CompoundByteIterable(iterables, 2));
            return result3;
        }
        boolean singleFile = log.isLastWrittenFileAddress(startAddress);
        if (!singleFile) {
            pos = 1;
            iterables[2] = mainIterable;
        } else {
            iterables[1] = mainIterable;
            result = log.tryWrite(type, structureId, (ByteIterable)new CompoundByteIterable(iterables, 2));
            if (result >= 0L) {
                return result;
            }
            pos = 1;
            iterables[2] = mainIterable;
        }
        type = (byte)(type + 16);
        iterables[pos] = CompressedUnsignedLongByteIterable.getIterable(log.getWrittenHighAddress() - startAddress);
        CompoundByteIterable data = new CompoundByteIterable(iterables, pos + 2);
        long l = result = singleFile ? log.writeContinuously(type, structureId, (ByteIterable)data) : log.tryWrite(type, structureId, (ByteIterable)data);
        if (result < 0L) {
            if (!singleFile) {
                iterables[pos] = CompressedUnsignedLongByteIterable.getIterable(log.getWrittenHighAddress() - startAddress);
                result = log.writeContinuously(type, structureId, (ByteIterable)new CompoundByteIterable(iterables, pos + 2));
                if (result >= 0L) {
                    return result;
                }
            }
            throw new TooBigLoggableException();
        }
        return result;
    }

    protected boolean isRoot() {
        return false;
    }

    private void copyChildrenFrom(@NotNull NodeBase node) {
        int childrenCount = node.getChildrenCount();
        this.children.clear(childrenCount);
        if (childrenCount > 0) {
            int i = 0;
            for (ChildReference child : node.getChildren()) {
                this.children.setAt(i++, child);
            }
            this.children.setSize(childrenCount);
        }
    }

    private byte getLoggableType() {
        byte result = 12;
        if (this.hasKey()) {
            result = (byte)(result + 1);
        }
        if (this.hasValue()) {
            result = (byte)(result + 2);
        }
        if (this.hasChildren()) {
            result = (byte)(result + 4);
        }
        if (this.isRoot()) {
            result = (byte)(result + 8);
        }
        return result;
    }

    private static final class MutableNodeChildrenIterator
    implements NodeChildrenIterator {
        @NotNull
        private final MutableNode node;
        @NotNull
        private final ChildReferenceSet.ChildReferenceIterator refs;
        private final ByteIterable key;
        private ChildReference ref;

        private MutableNodeChildrenIterator(@NotNull MutableNode node, @NotNull ChildReferenceSet refs) {
            this.node = node;
            this.refs = refs.iterator();
            this.key = node.keySequence;
        }

        private MutableNodeChildrenIterator(@NotNull MutableNode node, @NotNull ChildReferenceSet.ChildReferenceIterator refs) {
            this.node = node;
            this.refs = refs;
            this.ref = refs.currentRef();
            this.key = node.keySequence;
        }

        @Override
        public boolean hasNext() {
            return this.refs.hasNext();
        }

        @Override
        public ChildReference next() {
            this.ref = this.refs.next();
            return this.ref;
        }

        @Override
        public boolean hasPrev() {
            return this.refs.getIndex() > 0;
        }

        @Override
        public ChildReference prev() {
            this.ref = this.refs.prev();
            return this.ref;
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public void nextInPlace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void prevInPlace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChildReference getNode() {
            return this.ref;
        }

        @Override
        public void remove() {
            this.node.removeChild(this.ref.firstByte);
        }

        @Override
        public NodeBase getParentNode() {
            return this.node;
        }

        @Override
        public int getIndex() {
            return this.refs.getIndex();
        }

        @Override
        public ByteIterable getKey() {
            return this.key;
        }
    }
}

