/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import de.iip_ecosphere.platform.transport.status.Alert;
import de.iip_ecosphere.platform.transport.status.AlertSerializer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class AlertTest {
    @Test
    public void testAlerts() throws IOException {
        Alert e = new Alert();
        e.setUid("uid");
        e.setCorrelationId("corId");
        e.setTimestamp(1234L);
        e.setFirstTimestamp(1236L);
        e.setLastTimestamp(1239L);
        e.setClearTimestamp(1240L);
        e.setAlertname("alName");
        e.setSource("alSource");
        e.setInstance("alInst");
        e.setInfo("info");
        e.setTags("t1,t2");
        e.setSeverity("high");
        e.setPriority("high");
        e.setEventType("1234");
        e.setProbableCause("7");
        e.setCurrentValue("25");
        e.setUrl("http://a.b/c");
        e.setDescription("desc");
        e.setStatus("status");
        e.setRuleExpression("v < 25");
        e.setRuleTimeLimit("");
        AlertSerializer ser = new AlertSerializer();
        Alert e1 = ser.clone(e);
        this.assertAlert(e, e1);
        Assert.assertNotNull((Object)SerializerRegistry.getSerializer(Alert.class));
        e1 = ser.from(ser.to(e));
        this.assertAlert(e, e1);
    }

    private void assertAlert(Alert expected, Alert actual) {
        Assert.assertEquals((Object)expected.getUid(), (Object)actual.getUid());
        Assert.assertEquals((Object)expected.getCorrelationId(), (Object)actual.getCorrelationId());
        Assert.assertEquals((long)expected.getTimestamp(), (long)actual.getTimestamp());
        Assert.assertEquals((long)expected.getFirstTimestamp(), (long)actual.getFirstTimestamp());
        Assert.assertEquals((long)expected.getLastTimestamp(), (long)actual.getLastTimestamp());
        Assert.assertEquals((long)expected.getClearTimestamp(), (long)actual.getClearTimestamp());
        Assert.assertEquals((Object)expected.getAlertname(), (Object)actual.getAlertname());
        Assert.assertEquals((Object)expected.getSource(), (Object)actual.getSource());
        Assert.assertEquals((Object)expected.getInstance(), (Object)actual.getInstance());
        Assert.assertEquals((Object)expected.getInfo(), (Object)actual.getInfo());
        Assert.assertEquals((Object)expected.getTags(), (Object)actual.getTags());
        Assert.assertEquals((Object)expected.getSeverity(), (Object)actual.getSeverity());
        Assert.assertEquals((Object)expected.getPriority(), (Object)actual.getPriority());
        Assert.assertEquals((Object)expected.getEventType(), (Object)actual.getEventType());
        Assert.assertEquals((Object)expected.getProbableCause(), (Object)actual.getProbableCause());
        Assert.assertEquals((Object)expected.getCurrentValue(), (Object)actual.getCurrentValue());
        Assert.assertEquals((Object)expected.getUrl(), (Object)actual.getUrl());
        Assert.assertEquals((Object)expected.getDescription(), (Object)actual.getDescription());
        Assert.assertEquals((Object)expected.getStatus(), (Object)actual.getStatus());
        Assert.assertEquals((Object)expected.getRuleExpression(), (Object)actual.getRuleExpression());
        Assert.assertEquals((Object)expected.getRuleTimeLimit(), (Object)actual.getRuleTimeLimit());
    }
}

