/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.basics.MqttQoS;
import de.iip_ecosphere.platform.transport.connectors.impl.AbstractTransportConnector;
import org.junit.Assert;
import org.junit.Test;

public class TransportParameterTest {
    @Test
    public void testTransportParameter() {
        ServerAddress addr = new ServerAddress(Schema.IGNORE, "local", 1234);
        TransportParameter params = TransportParameter.TransportParameterBuilder.newBuilder((ServerAddress)addr).setActionTimeout(1235).setApplicationId("app").setAutoApplicationId(false).setKeepAlive(1236).setMqttQoS(null).setMqttQoS(MqttQoS.EXACTLY_ONCE).setCloseAction(null).setCloseAction(TransportParameter.CloseAction.NONE).build();
        Assert.assertEquals((Object)addr.getHost(), (Object)params.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)params.getPort());
        Assert.assertEquals((long)1235L, (long)params.getActionTimeout());
        Assert.assertEquals((Object)"app", (Object)params.getApplicationId());
        Assert.assertEquals((Object)false, (Object)params.getAutoApplicationId());
        Assert.assertEquals((long)1236L, (long)params.getKeepAlive());
        Assert.assertEquals(null, (Object)params.getKeystoreKey());
        Assert.assertEquals((Object)MqttQoS.EXACTLY_ONCE, (Object)params.getMqttQoS());
        Assert.assertEquals((Object)TransportParameter.CloseAction.NONE, (Object)params.getCloseAction());
        params = TransportParameter.TransportParameterBuilder.newBuilder((TransportParameter)params).setMqttQoS(MqttQoS.AT_LEAST_ONCE).build();
        Assert.assertEquals((Object)addr.getHost(), (Object)params.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)params.getPort());
        Assert.assertEquals((long)1235L, (long)params.getActionTimeout());
        Assert.assertEquals((Object)"app", (Object)params.getApplicationId());
        Assert.assertEquals((Object)false, (Object)params.getAutoApplicationId());
        Assert.assertEquals((long)1236L, (long)params.getKeepAlive());
        Assert.assertEquals(null, (Object)params.getKeystoreKey());
        Assert.assertEquals((Object)MqttQoS.AT_LEAST_ONCE, (Object)params.getMqttQoS());
        Assert.assertEquals((Object)TransportParameter.CloseAction.NONE, (Object)params.getCloseAction());
    }

    @Test
    public void testTransportTlsParameter() {
        ServerAddress addr = new ServerAddress(Schema.IGNORE, "local", 1234);
        String alias = "alias";
        TransportParameter params = TransportParameter.TransportParameterBuilder.newBuilder((ServerAddress)addr).setKeystoreKey(null).build();
        Assert.assertEquals((Object)addr.getHost(), (Object)params.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)params.getPort());
        Assert.assertEquals(null, (Object)params.getKeystoreKey());
        Assert.assertEquals(null, (Object)params.getKeyAlias());
        Assert.assertFalse((boolean)params.getHostnameVerification());
        params = TransportParameter.TransportParameterBuilder.newBuilder((ServerAddress)addr).setKeystoreKey("myKeystore").setHostnameVerification(false).build();
        Assert.assertEquals((Object)addr.getHost(), (Object)params.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)params.getPort());
        Assert.assertEquals((Object)"myKeystore", (Object)params.getKeystoreKey());
        Assert.assertEquals(null, (Object)params.getKeyAlias());
        Assert.assertFalse((boolean)params.getHostnameVerification());
        params = TransportParameter.TransportParameterBuilder.newBuilder((ServerAddress)addr).setKeystoreKey("myKeystore").setKeyAlias(alias).setHostnameVerification(true).build();
        Assert.assertEquals((Object)addr.getHost(), (Object)params.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)params.getPort());
        Assert.assertEquals((Object)"myKeystore", (Object)params.getKeystoreKey());
        Assert.assertEquals((Object)alias, (Object)params.getKeyAlias());
        Assert.assertTrue((boolean)params.getHostnameVerification());
    }

    @Test
    public void testApplicationId() {
        Assert.assertEquals((Object)"", (Object)AbstractTransportConnector.getApplicationId(null, null, (boolean)false));
        Assert.assertEquals((Object)"", (Object)AbstractTransportConnector.getApplicationId((String)"", null, (boolean)false));
        Assert.assertEquals((Object)"", (Object)AbstractTransportConnector.getApplicationId(null, (String)"", (boolean)false));
        Assert.assertEquals((Object)"", (Object)AbstractTransportConnector.getApplicationId((String)"", (String)"", (boolean)false));
        Assert.assertEquals((Object)"a", (Object)AbstractTransportConnector.getApplicationId((String)"a", (String)"", (boolean)false));
        Assert.assertEquals((Object)"a-b", (Object)AbstractTransportConnector.getApplicationId((String)"a", (String)"b", (boolean)false));
        Assert.assertEquals((Object)"b", (Object)AbstractTransportConnector.getApplicationId((String)"", (String)"b", (boolean)false));
        Assert.assertTrue((boolean)AbstractTransportConnector.getApplicationId((String)"a", (String)"b", (boolean)true).startsWith("a-b-"));
    }
}

